/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrary.core.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SerializationUtils;
import org.jlibrary.core.http.client.HTTPRepositoryDelegate;
import org.jlibrary.core.profiles.HTTPServerProfile;
import org.jlibrary.core.util.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPDelegate {
    static Logger logger = LoggerFactory.getLogger(HTTPRepositoryDelegate.class);
    private URL servletURL;

    public HTTPDelegate(HTTPServerProfile profile, String serviceName) {
        String location;
        String servletURL = location = profile.getLocation();
        if (!servletURL.endsWith("/")) {
            servletURL = servletURL + "/";
        }
        servletURL = servletURL + serviceName;
        try {
            this.servletURL = new URL(servletURL);
        }
        catch (MalformedURLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void doVoidRequest(String methodName, Object[] params) throws Exception {
        this.doRequest(methodName, params, null, null);
    }

    public void doVoidRequest(String methodName, Object[] params, InputStream stream) throws Exception {
        this.doRequest(methodName, params, null, stream);
    }

    public Object doRequest(String methodName, Object[] params, Class returnClass) throws Exception {
        return this.doRequest(methodName, params, returnClass, null);
    }

    public Object doRequest(String methodName, Object[] params, Class returnClass, InputStream inputStream) throws Exception {
        try {
            logger.debug(this.servletURL.toString());
            logger.debug("opening connection");
            URLConnection conn = this.servletURL.openConnection();
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setAllowUserInteraction(false);
            conn.setRequestProperty("Content-type", "text/plain");
            OutputStream stream = conn.getOutputStream();
            if (inputStream != null) {
                stream.write(ByteUtils.intToByteArray((int)"stream-input".getBytes().length));
                stream.write("stream-input".getBytes());
                stream.flush();
            }
            if (returnClass == InputStream.class) {
                stream.write(ByteUtils.intToByteArray((int)"stream-output".getBytes().length));
                stream.write("stream-output".getBytes());
                stream.flush();
            }
            stream.write(ByteUtils.intToByteArray((int)methodName.getBytes().length));
            stream.write(methodName.getBytes());
            stream.write(ByteUtils.intToByteArray((int)params.length));
            for (int i = 0; i < params.length; ++i) {
                byte[] content = SerializationUtils.serialize((Serializable)((Serializable)params[i]));
                stream.write(ByteUtils.intToByteArray((int)content.length));
                stream.write(content);
                stream.flush();
            }
            if (inputStream != null) {
                IOUtils.copy((InputStream)inputStream, (OutputStream)stream);
            }
            InputStream input = conn.getInputStream();
            if (returnClass == InputStream.class) {
                return input;
            }
            ObjectInputStream objInput = new ObjectInputStream(input);
            Object o = objInput.readObject();
            if (o == null) {
                return null;
            }
            stream.close();
            if (o instanceof Exception) {
                throw (Exception)o;
            }
            if (returnClass == null) {
                return null;
            }
            try {
                returnClass.cast(o);
            }
            catch (ClassCastException cce) {
                String msg = "Unexpected response from execution servlet: " + o;
                logger.error(msg);
                throw new Exception(msg);
            }
            return o;
        }
        catch (ClassNotFoundException e) {
            throw new Exception(e);
        }
        catch (ClassCastException e) {
            throw new Exception(e);
        }
        catch (IOException e) {
            throw new Exception(e);
        }
    }
}

