/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrary.core.http.client;

import java.util.Collection;
import org.jlibrary.core.entities.Ticket;
import org.jlibrary.core.http.client.HTTPDelegate;
import org.jlibrary.core.profiles.HTTPServerProfile;
import org.jlibrary.core.search.SearchException;
import org.jlibrary.core.search.SearchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPSearchDelegate
extends HTTPDelegate
implements SearchService {
    static Logger logger = LoggerFactory.getLogger(HTTPSearchDelegate.class);

    public HTTPSearchDelegate(HTTPServerProfile profile) {
        super(profile, "HTTPSearchService");
    }

    public Collection search(Ticket ticket, String xpathQuery) throws SearchException {
        Collection collection = (Collection)this.doSearchRequest("search", new Object[]{ticket, xpathQuery}, Collection.class);
        return collection;
    }

    public Collection search(Ticket ticket, String phrase, String searchType) throws SearchException {
        Collection collection = (Collection)this.doSearchRequest("search", new Object[]{ticket, phrase, searchType}, Collection.class);
        return collection;
    }

    public void doVoidSearchRequest(String methodName, Object[] params) throws SearchException {
        try {
            this.doVoidRequest(methodName, params);
        }
        catch (Exception e) {
            if (e instanceof SearchException) {
                throw (SearchException)e;
            }
            throw new SearchException((Throwable)e);
        }
    }

    public Object doSearchRequest(String methodName, Object[] params, Class returnClass) throws SearchException {
        try {
            return this.doRequest(methodName, params, returnClass);
        }
        catch (Exception e) {
            if (e instanceof SearchException) {
                throw (SearchException)e;
            }
            throw new SearchException((Throwable)e);
        }
    }
}

