/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrary.core.http.client;

import java.net.ConnectException;
import java.util.Collection;
import org.jlibrary.core.entities.Credentials;
import org.jlibrary.core.entities.Group;
import org.jlibrary.core.entities.Rol;
import org.jlibrary.core.entities.Ticket;
import org.jlibrary.core.entities.User;
import org.jlibrary.core.http.client.HTTPDelegate;
import org.jlibrary.core.profiles.HTTPServerProfile;
import org.jlibrary.core.properties.GroupProperties;
import org.jlibrary.core.properties.RolProperties;
import org.jlibrary.core.properties.UserProperties;
import org.jlibrary.core.repository.exception.RepositoryNotFoundException;
import org.jlibrary.core.security.SecurityException;
import org.jlibrary.core.security.SecurityService;
import org.jlibrary.core.security.exception.AuthenticationException;
import org.jlibrary.core.security.exception.GroupNotFoundException;
import org.jlibrary.core.security.exception.RoleNotFoundException;
import org.jlibrary.core.security.exception.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPSecurityDelegate
extends HTTPDelegate
implements SecurityService {
    static Logger logger = LoggerFactory.getLogger(HTTPSecurityDelegate.class);

    public HTTPSecurityDelegate(HTTPServerProfile profile) {
        super(profile, "HTTPSecurityService");
    }

    public User createUser(Ticket ticket, UserProperties userProperties) throws SecurityException {
        User user = (User)this.doSecurityRequest("createUser", new Object[]{ticket, userProperties}, User.class);
        return user;
    }

    public User updateUser(Ticket ticket, UserProperties userProperties) throws SecurityException {
        User user = (User)this.doSecurityRequest("updateUser", new Object[]{ticket, userProperties}, User.class);
        return user;
    }

    public User findUserByName(Ticket ticket, String name) throws SecurityException, UserNotFoundException {
        User user = (User)this.doSecurityRequest("findUserByName", new Object[]{ticket, name}, User.class);
        return user;
    }

    public User findUserById(Ticket ticket, String userId) throws SecurityException, UserNotFoundException {
        User user = (User)this.doSecurityRequest("findUserById", new Object[]{ticket, userId}, User.class);
        return user;
    }

    public Collection findAllUsers(Ticket ticket) throws SecurityException {
        Collection collection = (Collection)this.doSecurityRequest("findAllUsers", new Object[]{ticket}, Collection.class);
        return collection;
    }

    public Collection findAllRoles(Ticket ticket) throws SecurityException {
        Collection collection = (Collection)this.doSecurityRequest("findAllRoles", new Object[]{ticket}, Collection.class);
        return collection;
    }

    public Collection findAllGroups(Ticket ticket) throws SecurityException {
        Collection collection = (Collection)this.doSecurityRequest("findAllGroups", new Object[]{ticket}, Collection.class);
        return collection;
    }

    public Rol createRol(Ticket ticket, RolProperties rolProperties) throws SecurityException {
        Rol rol = (Rol)this.doSecurityRequest("createRol", new Object[]{ticket, rolProperties}, Rol.class);
        return rol;
    }

    public Rol updateRol(Ticket ticket, RolProperties rolProperties) throws SecurityException {
        Rol rol = (Rol)this.doSecurityRequest("updateRol", new Object[]{ticket, rolProperties}, Rol.class);
        return rol;
    }

    public Rol findRol(Ticket ticket, String rolId) throws SecurityException, RoleNotFoundException {
        Rol rol = (Rol)this.doSecurityRequest("findRol", new Object[]{ticket, rolId}, Rol.class);
        return rol;
    }

    public Group createGroup(Ticket ticket, GroupProperties groupProperties) throws SecurityException {
        Group createGroup = (Group)this.doSecurityRequest("createGroup", new Object[]{ticket, groupProperties}, Group.class);
        return createGroup;
    }

    public Group updateGroup(Ticket ticket, GroupProperties groupProperties) throws SecurityException {
        Group createGroup = (Group)this.doSecurityRequest("updateGroup", new Object[]{ticket, groupProperties}, Group.class);
        return createGroup;
    }

    public Group findGroupById(Ticket ticket, String groupId) throws SecurityException, GroupNotFoundException {
        Group createGroup = (Group)this.doSecurityRequest("findGroupById", new Object[]{ticket, groupId}, Group.class);
        return createGroup;
    }

    public void removeUser(Ticket ticket, String userId) throws SecurityException {
        this.doVoidSecurityRequest("removeUser", new Object[]{ticket, userId});
    }

    public void removeRol(Ticket ticket, String rolId) throws SecurityException {
        this.doVoidSecurityRequest("removeRol", new Object[]{ticket, rolId});
    }

    public void removeGroup(Ticket ticket, String groupId) throws SecurityException {
        this.doVoidSecurityRequest("removeGroup", new Object[]{ticket, groupId});
    }

    public Ticket login(Credentials credentials, String name) throws UserNotFoundException, AuthenticationException, SecurityException, ConnectException, RepositoryNotFoundException {
        try {
            Ticket ticket = (Ticket)this.doSecurityRequest("login", new Object[]{credentials, name}, Ticket.class);
            return ticket;
        }
        catch (SecurityException e) {
            if (((Object)((Object)e)).getClass() == UserNotFoundException.class) {
                throw (UserNotFoundException)e;
            }
            if (((Object)((Object)e)).getClass() == AuthenticationException.class) {
                throw (AuthenticationException)e;
            }
            if (e.getCause().getClass() == RepositoryNotFoundException.class) {
                throw (RepositoryNotFoundException)e.getCause();
            }
            if (e.getCause() != null && e.getCause().getClass() == ConnectException.class) {
                throw (ConnectException)e.getCause();
            }
            throw e;
        }
    }

    public void disconnect(Ticket ticket) throws SecurityException {
        this.doVoidSecurityRequest("disconnect", new Object[]{ticket});
    }

    public Collection findAllRestrictions(Ticket ticket, String nodeId) throws SecurityException {
        Collection collection = (Collection)this.doSecurityRequest("findAllRestrictions", new Object[]{ticket, nodeId}, Collection.class);
        return collection;
    }

    public void doVoidSecurityRequest(String methodName, Object[] params) throws SecurityException {
        try {
            this.doVoidRequest(methodName, params);
        }
        catch (Exception e) {
            if (e instanceof SecurityException) {
                throw (SecurityException)((Object)e);
            }
            throw new SecurityException((Throwable)e);
        }
    }

    public Object doSecurityRequest(String methodName, Object[] params, Class returnClass) throws SecurityException {
        try {
            return this.doRequest(methodName, params, returnClass);
        }
        catch (Exception e) {
            if (e instanceof SecurityException) {
                throw (SecurityException)((Object)e);
            }
            throw new SecurityException((Throwable)e);
        }
    }
}

