/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrary.servlet;

import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jlibrary.core.jcr.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JLibraryStartupContextListener
implements ServletContextListener {
    static Logger logger = LoggerFactory.getLogger(JLibraryStartupContextListener.class);

    public void contextDestroyed(ServletContextEvent arg0) {
        logger.info("Stoping jlibrary...");
        SessionManager.shutdown();
        logger.info("JLibrary stopped!.");
    }

    public void contextInitialized(ServletContextEvent sce) {
        logger.info("Configuring security environment...");
        this.configureEnvironment(sce.getServletContext());
        logger.info("Configuration done!.");
    }

    private void configureEnvironment(ServletContext sc) {
        try {
            Properties env = new Properties();
            Enumeration names = sc.getInitParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!name.startsWith("java.naming.")) continue;
                env.put(name, sc.getInitParameter(name));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

