/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrary.servlet.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.SerializationUtils;
import org.jlibrary.core.util.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HTTPStreamingServlet
extends HttpServlet {
    private static final long serialVersionUID = 7520606671931567655L;
    static Logger logger = LoggerFactory.getLogger(HTTPStreamingServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (logger.isDebugEnabled()) {
            logger.error("The service doesn't support GET method");
        }
        super.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Received a POST request");
        }
        try {
            ServletInputStream stream = req.getInputStream();
            byte[] count = this.read((InputStream)stream, 4);
            int messageNameSize = ByteUtils.byteArrayToInt((byte[])count);
            byte[] messageNameBuffer = this.read((InputStream)stream, messageNameSize);
            String callMethodName = new String(messageNameBuffer);
            Object returnValue = null;
            boolean streamOutput = false;
            boolean streamInput = false;
            if (callMethodName.equals("stream-input")) {
                streamInput = true;
                count = this.read((InputStream)stream, 4);
                messageNameSize = ByteUtils.byteArrayToInt((byte[])count);
                messageNameBuffer = this.read((InputStream)stream, messageNameSize);
                callMethodName = new String(messageNameBuffer);
            } else if (callMethodName.equals("stream-output")) {
                streamOutput = true;
                count = this.read((InputStream)stream, 4);
                messageNameSize = ByteUtils.byteArrayToInt((byte[])count);
                messageNameBuffer = this.read((InputStream)stream, messageNameSize);
                callMethodName = new String(messageNameBuffer);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Calling method: " + callMethodName);
            }
            count = this.read((InputStream)stream, 4);
            int parameters = ByteUtils.byteArrayToInt((byte[])count);
            Object[] params = new Object[parameters];
            if (!streamInput && !streamOutput) {
                params = new Object[parameters];
            } else {
                params = new Object[parameters + 1];
                if (streamInput) {
                    params[parameters] = stream;
                } else if (streamOutput) {
                    params[parameters] = resp.getOutputStream();
                }
            }
            for (int i = 0; i < parameters; ++i) {
                count = this.read((InputStream)stream, 4);
                int parameterSize = ByteUtils.byteArrayToInt((byte[])count);
                byte[] parameterBuffer = this.read((InputStream)stream, parameterSize);
                params[i] = SerializationUtils.deserialize((byte[])parameterBuffer);
            }
            try {
                if (!streamInput && !streamOutput) {
                    returnValue = this.handleRequest(req, callMethodName, params);
                } else if (streamInput) {
                    returnValue = this.handleRequest(req, callMethodName, params, InputStream.class);
                } else if (streamOutput) {
                    returnValue = this.handleRequest(req, callMethodName, params, OutputStream.class);
                }
            }
            catch (InvocationTargetException ite) {
                returnValue = ite.getCause();
                if (returnValue == null) {
                    returnValue = ite.getTargetException();
                }
            }
            catch (Exception e) {
                returnValue = e;
            }
            if (!streamOutput) {
                this.handleReturnValue(resp, returnValue);
            }
        }
        catch (IOException e) {
            logger.error("IOException in doPost", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Exception in doPost", (Throwable)e);
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug("POST request handled successfully");
            }
        }
    }

    private void handleReturnValue(HttpServletResponse resp, Object returnValue) throws IOException {
        new ObjectOutputStream((OutputStream)resp.getOutputStream()).writeObject(returnValue);
    }

    protected abstract Object getDelegate() throws Exception;

    protected Object handleRequest(HttpServletRequest request, String callMethodName, Object[] params) throws Exception {
        return this.handleRequest(request, callMethodName, params, null);
    }

    protected Object handleRequest(HttpServletRequest request, String callMethodName, Object[] params, Class streamClass) throws Exception {
        int i;
        Class<?> clazz = this.getDelegate().getClass();
        Class[] paramTypes = new Class[params.length];
        if (streamClass == null) {
            for (i = 0; i < params.length; ++i) {
                paramTypes[i] = params[i].getClass();
            }
        } else {
            for (i = 0; i < params.length - 1; ++i) {
                paramTypes[i] = params[i].getClass();
            }
            paramTypes[params.length - 1] = streamClass;
        }
        for (i = 0; i < paramTypes.length; ++i) {
            if (!paramTypes[i].getName().equals("java.util.ArrayList")) continue;
            paramTypes[i] = List.class;
        }
        if (logger.isDebugEnabled()) {
            this.debugMethodCall(callMethodName, paramTypes);
        }
        Method method = clazz.getMethod(callMethodName, paramTypes);
        Object returnValue = method.invoke(this.getDelegate(), params);
        return returnValue;
    }

    protected void debugMethodCall(String callMethodName, Class[] paramTypes) {
        StringBuffer logMessage = new StringBuffer("Calling method " + callMethodName + " with params [");
        for (Class c : paramTypes) {
            logMessage.append(c.getName());
            logMessage.append(",");
        }
        logMessage.replace(logMessage.length() - 1, logMessage.length(), "]");
        logger.debug(logMessage.toString());
    }

    private byte[] read(InputStream stream, int bytes) throws IOException {
        byte[] content = new byte[bytes];
        int read = 0;
        while (read < bytes) {
            if (bytes - read > 1024) {
                read += stream.read(content, read, 1024);
                continue;
            }
            read += stream.read(content, read, bytes - read);
        }
        return content;
    }
}

