/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jline.builtins.Builtins;
import org.jline.builtins.CommandRegistry;
import org.jline.builtins.Completers;
import org.jline.builtins.ConsoleEngine;
import org.jline.builtins.Nano;
import org.jline.builtins.Options;
import org.jline.builtins.SystemRegistry;
import org.jline.builtins.SystemRegistryImpl;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.ConfigurationPath;
import org.jline.reader.EOFError;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.ScriptEngine;
import org.jline.reader.SyntaxError;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class ConsoleEngineImpl
implements ConsoleEngine {
    private static final String VAR_CONSOLE_OPTIONS = "CONSOLE_OPTIONS";
    private static final String VAR_PRNT_OPTIONS = "PRNT_OPTIONS";
    private static final String VAR_PATH = "PATH";
    private static final String VAR_NANORC = "NANORC";
    private static final String[] OPTION_HELP = new String[]{"-?", "--help"};
    private static final String OPTION_VERBOSE = "-v";
    private static final String END_HELP = "END_HELP";
    private static final int HELP_MAX_SIZE = 30;
    private final ScriptEngine engine;
    private Map<Command, String> commandName = new HashMap<Command, String>();
    private Map<String, Command> nameCommand = new HashMap<String, Command>();
    private Map<String, String> aliasCommand = new HashMap<String, String>();
    private final Map<Command, Builtins.CommandMethods> commandExecute = new HashMap<Command, Builtins.CommandMethods>();
    private Exception exception;
    private SystemRegistry systemRegistry;
    private String scriptExtension = "jline";
    private final Supplier<Path> workDir;
    private final ConfigurationPath configPath;
    private final Map<String, String> aliases = new HashMap<String, String>();
    private final Map<String, List<String>> pipes = new HashMap<String, List<String>>();
    private Path aliasFile;
    private LineReader reader;
    private boolean executing = false;

    public ConsoleEngineImpl(ScriptEngine engine, Supplier<Path> workDir, ConfigurationPath configPath) throws IOException {
        this.engine = engine;
        this.workDir = workDir;
        this.configPath = configPath;
        HashSet<Command> cmds = new HashSet<Command>(EnumSet.allOf(Command.class));
        for (Command c : cmds) {
            this.commandName.put(c, c.name().toLowerCase());
        }
        this.doNameCommand();
        this.commandExecute.put(Command.DEL, new Builtins.CommandMethods(this::del, this::variableCompleter));
        this.commandExecute.put(Command.SHOW, new Builtins.CommandMethods(this::show, this::variableCompleter));
        this.commandExecute.put(Command.PRNT, new Builtins.CommandMethods(this::prnt, this::prntCompleter));
        this.commandExecute.put(Command.SLURP, new Builtins.CommandMethods(this::slurpcmd, this::slurpCompleter));
        this.commandExecute.put(Command.ALIAS, new Builtins.CommandMethods(this::aliascmd, this::aliasCompleter));
        this.commandExecute.put(Command.UNALIAS, new Builtins.CommandMethods(this::unalias, this::unaliasCompleter));
        this.commandExecute.put(Command.PIPE, new Builtins.CommandMethods(this::pipe, this::pipeCompleter));
        this.aliasFile = configPath.getUserConfig("aliases.json");
        if (this.aliasFile == null) {
            this.aliasFile = configPath.getUserConfig("aliases.json", true);
            engine.persist(this.aliasFile, this.aliases);
        } else {
            this.aliases.putAll((Map)this.slurp(this.aliasFile));
        }
    }

    @Override
    public void setLineReader(LineReader reader) {
        this.reader = reader;
    }

    private Parser parser() {
        return this.reader.getParser();
    }

    private Terminal terminal() {
        return this.systemRegistry.terminal();
    }

    @Override
    public boolean isExecuting() {
        return this.executing;
    }

    @Override
    public void setSystemRegistry(SystemRegistry systemRegistry) {
        this.systemRegistry = systemRegistry;
    }

    @Override
    public void setScriptExtension(String extension) {
        this.scriptExtension = extension;
    }

    @Override
    public Set<String> commandNames() {
        return this.nameCommand.keySet();
    }

    @Override
    public Map<String, String> commandAliases() {
        return this.aliasCommand;
    }

    @Override
    public boolean hasCommand(String name) {
        return this.nameCommand.containsKey(name) || this.aliasCommand.containsKey(name);
    }

    @Override
    public boolean hasAlias(String name) {
        return this.aliases.containsKey(name);
    }

    @Override
    public String getAlias(String name) {
        return this.aliases.getOrDefault(name, null);
    }

    @Override
    public Map<String, List<String>> getPipes() {
        return this.pipes;
    }

    private void doNameCommand() {
        this.nameCommand = this.commandName.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    private Command command(String name) {
        Command out = null;
        if (!this.hasCommand(name)) {
            throw new IllegalArgumentException("Command does not exists!");
        }
        if (this.aliasCommand.containsKey(name)) {
            name = this.aliasCommand.get(name);
        }
        if (!this.nameCommand.containsKey(name)) {
            throw new IllegalArgumentException("Command does not exists!");
        }
        out = this.nameCommand.get(name);
        return out;
    }

    public void rename(Command command, String newName) {
        if (this.nameCommand.containsKey(newName)) {
            throw new IllegalArgumentException("Duplicate command name!");
        }
        if (!this.commandName.containsKey((Object)command)) {
            throw new IllegalArgumentException("Command does not exists!");
        }
        this.commandName.put(command, newName);
        this.doNameCommand();
    }

    public void alias(String alias, String command) {
        if (!this.nameCommand.keySet().contains(command)) {
            throw new IllegalArgumentException("Command does not exists!");
        }
        this.aliasCommand.put(alias, command);
    }

    @Override
    public Completers.SystemCompleter compileCompleters() {
        Completers.SystemCompleter out = new Completers.SystemCompleter();
        for (Map.Entry<Command, String> entry : this.commandName.entrySet()) {
            out.add(entry.getValue(), this.commandExecute.get((Object)entry.getKey()).compileCompleter().apply(entry.getValue()));
        }
        out.addAliases(this.aliasCommand);
        return out;
    }

    private Set<String> variables() {
        return this.engine.find().keySet();
    }

    @Override
    public List<Completer> scriptCompleters() {
        ArrayList<Completer> out = new ArrayList<Completer>();
        out.add((Completer)new ArgumentCompleter(new Completer[]{new StringsCompleter(this::variables), NullCompleter.INSTANCE}));
        out.add((Completer)new ArgumentCompleter(new Completer[]{new StringsCompleter(this::scriptNames), new Completers.OptionCompleter((Completer)NullCompleter.INSTANCE, this::commandOptions, 1)}));
        Completer[] completerArray = new Completer[2];
        completerArray[0] = new StringsCompleter(this.aliases::keySet);
        completerArray[1] = NullCompleter.INSTANCE;
        out.add((Completer)new ArgumentCompleter(completerArray));
        return out;
    }

    private Set<String> scriptNames() {
        return this.scripts().keySet();
    }

    @Override
    public Map<String, Boolean> scripts() {
        HashMap<String, Boolean> out = new HashMap<String, Boolean>();
        try {
            ArrayList scripts = new ArrayList();
            if (this.engine.hasVariable(VAR_PATH)) {
                for (String pp : (List)this.engine.get(VAR_PATH)) {
                    for (String e : this.scriptExtensions()) {
                        String regex = pp + "/*." + e;
                        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + regex);
                        Files.find(Paths.get(new File(regex).getParent(), new String[0]), Integer.MAX_VALUE, (path, f) -> pathMatcher.matches((Path)path), new FileVisitOption[0]).forEach(p -> scripts.add(p));
                    }
                }
            }
            for (Path p2 : scripts) {
                String name = p2.toFile().getName();
                int idx = name.lastIndexOf(".");
                out.put(name.substring(0, idx), name.substring(idx + 1).equals(this.scriptExtension));
            }
        }
        catch (NoSuchFileException e) {
            this.error("Failed reading PATH. No file found: " + e.getMessage());
        }
        catch (InvalidPathException e) {
            this.error("Failed reading PATH. Invalid path:");
            this.error(e.toString());
        }
        catch (Exception e) {
            this.error("Failed reading PATH:");
            this.trace(e);
            this.engine.put("exception", (Object)e);
        }
        return out;
    }

    @Override
    public Object[] expandParameters(String[] args) throws Exception {
        Object[] out = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            out[i] = args[i].startsWith("${") ? this.engine.execute(this.expandName(args[i])) : (args[i].startsWith("$") ? this.engine.get(this.expandName(args[i])) : this.engine.expandParameter(args[i]));
        }
        return out;
    }

    private String expandName(String name) {
        String regexVar = "[a-zA-Z_]{1,}[a-zA-Z0-9_-]*";
        String out = name;
        if (name.matches("^\\$" + regexVar)) {
            out = name.substring(1);
        } else if (name.matches("^\\$\\{" + regexVar + "\\}.*")) {
            Matcher matcher = Pattern.compile("^\\$\\{(" + regexVar + ")\\}(.*)").matcher(name);
            if (matcher.find()) {
                out = matcher.group(1) + matcher.group(2);
            } else {
                throw new IllegalArgumentException();
            }
        }
        return out;
    }

    private boolean isCodeBlock(String line) {
        return line.contains("\n") && line.trim().endsWith("}");
    }

    private boolean isCommandLine(String line) {
        String command = this.parser().getCommand(line);
        boolean out = false;
        if (command != null && command.startsWith(":")) {
            if (this.systemRegistry.hasCommand(command.substring(1))) {
                out = true;
            } else {
                ScriptFile sf = new ScriptFile(command.substring(1), "", new String[0]);
                if (sf.isScript()) {
                    out = true;
                }
            }
        }
        return out;
    }

    private String quote(String var) {
        if (var.startsWith("\"") && var.endsWith("\"") || var.startsWith("'") && var.endsWith("'")) {
            return var;
        }
        if (var.contains("\\\"")) {
            return "'" + var + "'";
        }
        return "\"" + var + "\"";
    }

    private List<String> scriptExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.addAll(this.engine.getExtensions());
        extensions.add(this.scriptExtension);
        return extensions;
    }

    @Override
    public Object execute(File script, String cmdLine, String[] args) throws Exception {
        ScriptFile file = new ScriptFile(script, cmdLine, args);
        file.execute();
        return file.getResult();
    }

    @Override
    public Object execute(String cmd, String line, String[] args) throws Exception {
        if (line.trim().startsWith("#")) {
            return null;
        }
        Object out = null;
        ScriptFile file = null;
        if (this.parser().validCommandName(cmd)) {
            file = new ScriptFile(cmd, line, args);
        } else {
            File f = new File(line.split("\\s+")[0]);
            if (f.exists()) {
                file = new ScriptFile(f, line, args);
            }
        }
        if (file != null && file.execute()) {
            out = file.getResult();
        } else {
            if (this.isCodeBlock(line = line.trim())) {
                StringBuilder sb = new StringBuilder();
                for (String s : line.split("\\r?\\n")) {
                    if (this.isCommandLine(s)) {
                        int i;
                        List ws = this.parser().parse(s, 0, Parser.ParseContext.COMPLETE).words();
                        int idx = ((String)ws.get(0)).lastIndexOf(":");
                        if (idx > 0) {
                            sb.append(((String)ws.get(0)).substring(0, idx));
                        }
                        String[] argv = new String[ws.size()];
                        for (i = 1; i < ws.size(); ++i) {
                            argv[i] = (String)ws.get(i);
                            if (argv[i].startsWith("${")) {
                                Matcher argvMatcher = Pattern.compile("\\$\\{(.*)}").matcher(argv[i]);
                                if (!argvMatcher.find()) continue;
                                argv[i] = argv[i].replace(argv[i], argvMatcher.group(1));
                                continue;
                            }
                            argv[i] = argv[i].startsWith("$") ? argv[i].substring(1) : this.quote(argv[i]);
                        }
                        sb.append("org.jline.builtins.SystemRegistry.get().invoke('" + ((String)ws.get(0)).substring(idx + 1) + "'");
                        for (i = 1; i < argv.length; ++i) {
                            sb.append(", ");
                            sb.append(argv[i]);
                        }
                        sb.append(")");
                    } else {
                        sb.append(s);
                    }
                    sb.append("\n");
                }
                line = sb.toString();
            }
            if (this.engine.hasVariable(line)) {
                out = this.engine.get(line);
            } else if (this.parser().getVariable(line) == null) {
                out = this.engine.execute(line);
                this.engine.put("_", out);
            } else {
                this.engine.execute(line);
            }
        }
        return out;
    }

    @Override
    public void purge() {
        this.engine.del(new String[]{"_*"});
    }

    @Override
    public void putVariable(String name, Object value) {
        this.engine.put(name, value);
    }

    @Override
    public Object getVariable(String name) {
        if (!this.engine.hasVariable(name)) {
            throw new IllegalArgumentException("Variable " + name + " does not exists!");
        }
        return this.engine.get(name);
    }

    @Override
    public boolean hasVariable(String name) {
        return this.engine.hasVariable(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeWidget(Object function) {
        this.engine.put("_reader", (Object)this.reader);
        this.engine.put("_widgetFunction", function);
        try {
            if (this.engine.getEngineName().equals("GroovyEngine")) {
                this.engine.execute("def _buffer() {_reader.getBuffer()}");
                this.engine.execute("def _widget(w) {_reader.callWidget(w)}");
            }
            this.engine.execute("_widgetFunction()");
        }
        catch (Exception e) {
            this.trace(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.purge();
        }
        return true;
    }

    private <T> T consoleOption(String option, T defval) {
        T out = defval;
        try {
            if (this.engine.hasVariable(VAR_CONSOLE_OPTIONS)) {
                out = ((Map)this.engine.get(VAR_CONSOLE_OPTIONS)).getOrDefault(option, defval);
            }
        }
        catch (Exception e) {
            this.trace(new Exception("Bad CONSOLE_OPTION value: " + e.getMessage()));
        }
        return out;
    }

    @Override
    public ConsoleEngine.ExecutionResult postProcess(String line, Object result, String output) {
        ConsoleEngine.ExecutionResult out = new ConsoleEngine.ExecutionResult(1, null);
        String[] _output = output != null && !output.trim().isEmpty() && this.consoleOption("splitOutput", true) != false ? output.split("\\r?\\n") : output;
        String consoleVar = this.parser().getVariable(line);
        if (consoleVar != null && result != null) {
            this.engine.put("output", (Object)_output);
        }
        if (this.systemRegistry.hasCommand(this.parser().getCommand(line))) {
            out = this.postProcess(line, consoleVar != null && result == null ? _output : result);
        } else {
            String[] _result = result == null ? _output : result;
            int status = this.saveResult(consoleVar, _result);
            out = new ConsoleEngine.ExecutionResult(status, consoleVar != null && !consoleVar.startsWith("_") ? null : _result);
        }
        return out;
    }

    private ConsoleEngine.ExecutionResult postProcess(String line, Object result) {
        int status = 0;
        Object out = result != null && result instanceof String && ((String)result).trim().isEmpty() ? null : result;
        String consoleVar = this.parser().getVariable(line);
        if (consoleVar != null) {
            status = this.saveResult(consoleVar, result);
            if (!consoleVar.startsWith("_")) {
                out = null;
            }
        } else if (!this.parser().getCommand(line).equals("show")) {
            status = result != null ? this.saveResult("_", result) : 1;
        }
        return new ConsoleEngine.ExecutionResult(status, out);
    }

    @Override
    public ConsoleEngine.ExecutionResult postProcess(Object result) {
        return new ConsoleEngine.ExecutionResult(this.saveResult(null, result), result);
    }

    private int saveResult(String var, Object result) {
        int out = 0;
        try {
            this.engine.put("_executionResult", result);
            if (var != null) {
                if (var.contains(".") || var.contains("[")) {
                    this.engine.execute(var + " = _executionResult");
                } else {
                    this.engine.put(var, result);
                }
            }
            out = (Integer)this.engine.execute("_executionResult ? 0 : 1");
        }
        catch (Exception e) {
            this.trace(e);
            out = 1;
        }
        return out;
    }

    @Override
    public Object invoke(CommandRegistry.CommandSession session, String command, Object ... args) throws Exception {
        this.exception = null;
        Object out = null;
        if (this.hasCommand(command)) {
            out = this.commandExecute.get((Object)this.command(command)).executeFunction().apply(new Builtins.CommandInput(null, args, session));
        } else {
            String[] _args = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof String)) {
                    throw new IllegalArgumentException();
                }
                _args[i] = args[i].toString();
            }
            ScriptFile sf = new ScriptFile(command, "", _args);
            if (sf.execute()) {
                out = sf.getResult();
            }
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return out;
    }

    private Map<String, Object> defaultPrntOptions() {
        HashMap<String, Object> out = new HashMap<String, Object>();
        if (this.engine.hasVariable(VAR_PRNT_OPTIONS)) {
            out.putAll((Map)this.engine.get(VAR_PRNT_OPTIONS));
        }
        return out;
    }

    @Override
    public void trace(Object object) {
        Object toPrint = object;
        int level = this.consoleOption("trace", 0);
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (level < 2) {
            options.put("exception", "message");
        }
        if (level == 0) {
            if (!(object instanceof Exception)) {
                toPrint = null;
            }
        } else if (level == 1 && object instanceof SystemRegistryImpl.CommandData) {
            toPrint = ((SystemRegistryImpl.CommandData)object).rawLine();
        }
        this.println(options, toPrint);
    }

    private void error(String message) {
        this.highlight(1, (Object)message).println(this.terminal());
    }

    @Override
    public void println(Object object) {
        Map<String, Object> options = this.defaultPrntOptions();
        this.println(options, object);
    }

    @Override
    public void println(Map<String, Object> options, Object object) {
        if (object == null) {
            return;
        }
        options.putIfAbsent("width", this.terminal().getSize().getColumns());
        String style = (String)options.getOrDefault("style", "");
        int width = (Integer)options.get("width");
        if (style.equalsIgnoreCase("JSON")) {
            this.highlightAndPrint(width, style, this.engine.toJson(object));
        } else if (!style.isEmpty() && object instanceof String) {
            this.highlightAndPrint(width, style, (String)object);
        } else if (object instanceof Exception) {
            this.systemRegistry.trace(options.getOrDefault("exception", "stack").equals("stack"), (Exception)object);
        } else if (object instanceof String) {
            this.highlight(11, object).println(this.terminal());
        } else if (object instanceof Number) {
            this.highlight(12, object).println(this.terminal());
        } else {
            for (AttributedString as : this.highlight(options, object)) {
                as.println(this.terminal());
            }
        }
        this.terminal().flush();
    }

    private AttributedString highlight(int attrStyle, Object obj) {
        AttributedString out = new AttributedString((CharSequence)"");
        AttributedStringBuilder asb = new AttributedStringBuilder();
        String tp = obj.toString();
        if (!tp.isEmpty()) {
            asb.append((CharSequence)tp, AttributedStyle.DEFAULT.foreground(attrStyle));
            out = asb.toAttributedString();
        }
        return out;
    }

    private void highlightAndPrint(int width, String style, String object) {
        Path nanorc;
        Path path = nanorc = this.configPath != null ? this.configPath.getConfig("jnanorc") : null;
        if (this.engine.hasVariable(VAR_NANORC)) {
            nanorc = Paths.get((String)this.engine.get(VAR_NANORC), new String[0]);
        }
        if (nanorc == null) {
            nanorc = Paths.get("/etc/nanorc", new String[0]);
        }
        Nano.SyntaxHighlighter highlighter = nanorc != null ? Nano.SyntaxHighlighter.build(nanorc, style) : null;
        for (String s : object.split("\\r?\\n")) {
            AttributedStringBuilder asb = new AttributedStringBuilder();
            asb.append((CharSequence)s);
            if (highlighter != null) {
                highlighter.highlight(asb).println(this.terminal());
                continue;
            }
            asb.subSequence(0, width).println(this.terminal());
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<AttributedString> highlight(Map<String, Object> options, Object obj) {
        List<AttributedString> out = new ArrayList<AttributedString>();
        int width = (Integer)options.getOrDefault("width", Integer.MAX_VALUE);
        boolean rownum = options.containsKey("rownum");
        if (obj != null) {
            if (obj instanceof Map) {
                out = this.highlightMap((Map)obj, width);
            } else if (obj instanceof Collection || obj instanceof Object[]) {
                List<Object> collection;
                List<Object> list = collection = obj instanceof Collection ? (List<Object>)obj : Arrays.asList((Object[])obj);
                if (!collection.isEmpty()) {
                    if (collection.size() == 1) {
                        Object elem = collection.iterator().next();
                        if (elem instanceof Map) {
                            out = this.highlightMap((Map)elem, width);
                        } else {
                            out.add(new AttributedString((CharSequence)this.engine.toString(obj)));
                        }
                    } else {
                        Object elem = collection.iterator().next();
                        if (elem instanceof Map) {
                            void var12_27;
                            void var11_19;
                            Map map = (Map)elem;
                            ArrayList header = new ArrayList();
                            header.addAll(map.keySet());
                            ArrayList<Integer> columns = new ArrayList<Integer>();
                            boolean bl = false;
                            while (var11_19 < header.size()) {
                                columns.add(((String)header.get((int)var11_19)).length() + 1);
                                ++var11_19;
                            }
                            for (Object e : collection) {
                                for (int i = 0; i < header.size(); ++i) {
                                    Map map2 = (Map)e;
                                    if (this.engine.toString(map2.get(header.get(i))).length() <= (Integer)columns.get(i) - 1) continue;
                                    columns.set(i, this.engine.toString(map2.get(header.get(i))).length() + 1);
                                }
                            }
                            columns.add(0, 0);
                            this.toTabStops(columns, rownum);
                            AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder().tabs(columns);
                            if (rownum) {
                                attributedStringBuilder.append((CharSequence)"\t");
                            }
                            boolean bl2 = false;
                            while (var12_27 < header.size()) {
                                attributedStringBuilder.append((CharSequence)header.get((int)var12_27), AttributedStyle.DEFAULT.foreground(12));
                                attributedStringBuilder.append((CharSequence)"\t");
                                ++var12_27;
                            }
                            out.add(this.truncate(attributedStringBuilder, width));
                            Integer n = 0;
                            for (Object e : collection) {
                                AttributedStringBuilder asb2 = new AttributedStringBuilder().tabs(columns);
                                if (rownum) {
                                    Integer n2;
                                    void var12_29;
                                    asb2.append((CharSequence)var12_29.toString(), AttributedStyle.DEFAULT.foreground(12));
                                    asb2.append((CharSequence)"\t");
                                    void var16_52 = var12_29;
                                    Integer n3 = n2 = Integer.valueOf(var12_29.intValue() + 1);
                                }
                                for (int i = 0; i < header.size(); ++i) {
                                    Map m = (Map)e;
                                    asb2.append((CharSequence)this.engine.toString(m.get(header.get(i))));
                                    asb2.append((CharSequence)"\t");
                                }
                                out.add(asb2.subSequence(0, width));
                            }
                        } else if (elem instanceof Collection || elem instanceof Object[]) {
                            boolean isCollection = elem instanceof Collection;
                            ArrayList<Integer> columns = new ArrayList<Integer>();
                            for (Object e : collection) {
                                ArrayList<Object> arrayList = new ArrayList<Object>();
                                arrayList.addAll(isCollection ? (List<Object>)e : Arrays.asList((Object[])e));
                                for (int i = 0; i < arrayList.size(); ++i) {
                                    int n = this.engine.toString(arrayList.get(i)).length() + 1;
                                    if (columns.size() <= i) {
                                        columns.add(n);
                                        continue;
                                    }
                                    if (n <= (Integer)columns.get(i)) continue;
                                    columns.set(i, n);
                                }
                            }
                            this.toTabStops(columns, rownum);
                            Integer row = 0;
                            for (Object e : collection) {
                                AttributedStringBuilder asb = new AttributedStringBuilder().tabs(columns);
                                if (rownum) {
                                    asb.append((CharSequence)row.toString(), AttributedStyle.DEFAULT.foreground(12));
                                    asb.append((CharSequence)"\t");
                                    Integer n = row;
                                    Integer asb2 = row = Integer.valueOf(row + 1);
                                }
                                ArrayList<Object> arrayList = new ArrayList<Object>();
                                arrayList.addAll(isCollection ? (List<Object>)e : Arrays.asList((Object[])e));
                                for (int i = 0; i < arrayList.size(); ++i) {
                                    asb.append((CharSequence)this.engine.toString(arrayList.get(i)));
                                    asb.append((CharSequence)"\t");
                                }
                                out.add(this.truncate(asb, width));
                            }
                        } else {
                            Integer row = 0;
                            Integer tabsize = Integer.valueOf(collection.size()).toString().length() + 1;
                            for (Object e : collection) {
                                AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder().tabs(tabsize.intValue());
                                if (rownum) {
                                    attributedStringBuilder.append((CharSequence)row.toString(), AttributedStyle.DEFAULT.foreground(12));
                                    attributedStringBuilder.append((CharSequence)"\t");
                                    Integer n = row;
                                    Integer n4 = row = Integer.valueOf(row + 1);
                                }
                                attributedStringBuilder.append((CharSequence)this.engine.toString(e));
                                out.add(this.truncate(attributedStringBuilder, width));
                            }
                        }
                    }
                }
            } else {
                out.add(new AttributedString((CharSequence)this.engine.toString(obj)));
            }
        }
        return out;
    }

    private AttributedString truncate(AttributedStringBuilder asb, int width) {
        return asb.columnLength() > width ? asb.subSequence(0, width) : asb.toAttributedString();
    }

    private void toTabStops(List<Integer> columns, boolean rownum) {
        if (rownum) {
            columns.add(0, 5);
        }
        for (int i = 1; i < columns.size(); ++i) {
            columns.set(i, columns.get(i - 1) + columns.get(i));
        }
    }

    private List<AttributedString> highlightMap(Map<String, Object> map, int width) {
        ArrayList<AttributedString> out = new ArrayList<AttributedString>();
        int max = map.keySet().stream().map(String::length).max(Integer::compareTo).get();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            AttributedStringBuilder asb = new AttributedStringBuilder().tabs(Arrays.asList(0, max + 1));
            asb.append((CharSequence)entry.getKey(), AttributedStyle.DEFAULT.foreground(12));
            if (map.size() == 1) {
                for (String v : this.engine.toString(entry.getValue()).split("\\r?\\n")) {
                    asb.append((CharSequence)"\t");
                    asb.append((CharSequence)v, AttributedStyle.DEFAULT.foreground(3));
                    out.add(this.truncate(asb, width));
                    asb = new AttributedStringBuilder().tabs(Arrays.asList(0, max + 1));
                }
                continue;
            }
            String v = this.engine.toString(entry.getValue());
            if (v.contains("\n")) {
                v = Arrays.asList(v.split("\\r?\\n")).toString();
            }
            asb.append((CharSequence)"\t");
            asb.append((CharSequence)v, AttributedStyle.DEFAULT.foreground(3));
            out.add(this.truncate(asb, width));
        }
        return out;
    }

    private Object show(Builtins.CommandInput input) {
        String[] usage = new String[]{"show -  list console variables", "Usage: show [VARIABLE]", "  -? --help                       Displays command help"};
        Options opt = Options.compile(usage).parse(input.args());
        if (opt.isSet("help")) {
            this.exception = new Options.HelpException(opt.usage());
            return null;
        }
        return this.engine.find(input.args().length > 0 ? input.args()[0] : null);
    }

    private Object del(Builtins.CommandInput input) {
        String[] usage = new String[]{"del -  delete console variables", "Usage: del [var1] ...", "  -? --help                       Displays command help"};
        Options opt = Options.compile(usage).parse(input.xargs());
        if (opt.isSet("help")) {
            this.exception = new Options.HelpException(opt.usage());
            return null;
        }
        this.engine.del(input.args());
        return null;
    }

    private Object prnt(Builtins.CommandInput input) {
        String[] usage = new String[]{"prnt -  print object", "Usage: prnt [OPTIONS] object", "  -? --help                       Displays command help", "  -r --rownum                     Display table row numbers", "  -s --style=STYLE                Use nanorc STYLE", "  -w --width=WIDTH                Display width (default terminal width)"};
        Options opt = Options.compile(usage).parse(input.xargs());
        if (opt.isSet("help")) {
            this.exception = new Options.HelpException(opt.usage());
            return null;
        }
        Map<String, Object> options = this.defaultPrntOptions();
        if (opt.isSet("style")) {
            options.put("style", opt.get("style"));
        }
        if (opt.isSet("width")) {
            options.put("width", opt.getNumber("width"));
        }
        if (opt.isSet("rownum")) {
            options.put("rownum", true);
        }
        options.put("exception", "stack");
        List<Object> args = opt.argObjects();
        if (args.size() > 0) {
            this.println(options, args.get(0));
        }
        return null;
    }

    private Object slurpcmd(Builtins.CommandInput input) {
        String[] usage = new String[]{"slurp -  slurp file context to string/object", "Usage: slurp [OPTIONS] file", "  -? --help                       Displays command help", "  -e --encoding=ENCODING          Encoding (default UTF-8)", "  -f --format=FORMAT              Serialization format"};
        Options opt = Options.compile(usage).parse(input.args());
        if (opt.isSet("help")) {
            this.exception = new Options.HelpException(opt.usage());
            return null;
        }
        Object out = null;
        try {
            if (!opt.args().isEmpty()) {
                Charset encoding = opt.isSet("encoding") ? Charset.forName(opt.get("encoding")) : StandardCharsets.UTF_8;
                String format = opt.isSet("format") ? opt.get("format") : "";
                out = this.slurp(Paths.get(opt.args().get(0), new String[0]), encoding, format);
            }
        }
        catch (Exception e) {
            this.exception = e;
        }
        return out;
    }

    private Object slurp(Path file) throws IOException {
        return this.slurp(file, StandardCharsets.UTF_8, "JSON");
    }

    private Object slurp(Path file, Charset encoding, String format) throws IOException {
        Object out = null;
        byte[] encoded = Files.readAllBytes(file);
        out = format.equalsIgnoreCase("TXT") ? new String(encoded, encoding) : this.engine.expandParameter(new String(encoded, encoding), format);
        return out;
    }

    private Object aliascmd(Builtins.CommandInput input) {
        String[] usage = new String[]{"alias -  create command alias", "Usage: alias [ALIAS] [COMMANDLINE]", "  -? --help                       Displays command help"};
        Options opt = Options.compile(usage).parse(input.args());
        if (opt.isSet("help")) {
            this.exception = new Options.HelpException(opt.usage());
            return null;
        }
        Map<String, String> out = null;
        try {
            List<String> args = opt.args();
            if (args.isEmpty()) {
                out = this.aliases;
            } else if (args.size() == 1) {
                out = this.aliases.getOrDefault(args.get(0), null);
            } else {
                for (int i = 1; i < args.size(); ++i) {
                    for (int j = 0; j < 10; ++j) {
                        args.set(i, args.get(i).replaceAll("%" + j, "\\$" + j));
                        args.set(i, args.get(i).replaceAll("%\\{" + j + "\\}", "\\$\\{" + j + "\\}"));
                        args.set(i, args.get(i).replaceAll("%\\{" + j + ":-", "\\$\\{" + j + ":-"));
                    }
                }
                this.aliases.put(args.get(0), String.join((CharSequence)" ", args.subList(1, args.size())));
                this.engine.persist(this.aliasFile, this.aliases);
            }
        }
        catch (Exception e) {
            this.exception = e;
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object unalias(Builtins.CommandInput input) {
        String[] usage = new String[]{"unalias -  remove command alias", "Usage: unalias [ALIAS...]", "  -? --help                       Displays command help"};
        Options opt = Options.compile(usage).parse(input.args());
        if (opt.isSet("help")) {
            this.exception = new Options.HelpException(opt.usage());
            return null;
        }
        Object out = null;
        try {
            for (String a : opt.args()) {
                this.aliases.remove(a);
            }
        }
        catch (Exception e) {
            this.exception = e;
        }
        finally {
            this.engine.persist(this.aliasFile, this.aliases);
        }
        return out;
    }

    private Object pipe(Builtins.CommandInput input) {
        String[] usage = new String[]{"pipe -  create/delete pipe operator", "Usage: pipe [OPERATOR] [PREFIX] [POSTFIX]", "       pipe --list", "       pipe --delete [OPERATOR...]", "  -? --help                       Displays command help", "  -d --delete                     Delete pipe operators", "  -l --list                       List pipe operators"};
        Options opt = Options.compile(usage).parse(input.args());
        if (opt.isSet("help")) {
            this.exception = new Options.HelpException(opt.usage());
            return null;
        }
        Map<String, List<String>> out = null;
        if (opt.isSet("delete")) {
            if (opt.args().size() == 1 && opt.args().get(0).equals("*")) {
                this.pipes.clear();
            } else {
                for (String p : opt.args()) {
                    this.pipes.remove(p.trim());
                }
            }
        } else if (opt.isSet("list") || opt.args().size() == 0) {
            out = this.pipes;
        } else if (opt.args().size() != 3) {
            this.exception = new IllegalArgumentException("Bad number of arguments!");
        } else if (this.systemRegistry.getPipeNames().contains(opt.args().get(0))) {
            this.exception = new IllegalArgumentException("Reserved pipe operator");
        } else {
            ArrayList<String> fixes = new ArrayList<String>();
            fixes.add(opt.args().get(1));
            fixes.add(opt.args().get(2));
            this.pipes.put(opt.args().get(0), fixes);
        }
        return out;
    }

    private List<Completers.OptDesc> commandOptions(String command) {
        try {
            this.invoke(new CommandRegistry.CommandSession(), command, "--help");
        }
        catch (Options.HelpException e) {
            return Builtins.compileCommandOptions(e.getMessage());
        }
        catch (Exception e) {
            this.trace(e);
        }
        return null;
    }

    private List<Completer> slurpCompleter(String command) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add((Completer)new ArgumentCompleter(new Completer[]{NullCompleter.INSTANCE, new Completers.OptionCompleter((Completer)new Completers.FilesCompleter(this.workDir), this::commandOptions, 1)}));
        return completers;
    }

    private List<Completer> variableCompleter(String command) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add((Completer)new StringsCompleter(() -> this.engine.find().keySet()));
        return completers;
    }

    private List<String> variableReferences() {
        ArrayList<String> out = new ArrayList<String>();
        for (String v : this.engine.find().keySet()) {
            out.add("$" + v);
        }
        return out;
    }

    private List<Completer> prntCompleter(String command) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add((Completer)new ArgumentCompleter(new Completer[]{NullCompleter.INSTANCE, new Completers.OptionCompleter((Completer)new StringsCompleter(this::variableReferences), this::commandOptions, 1)}));
        return completers;
    }

    private List<Completer> aliasCompleter(String command) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        Completer[] completerArray = new Completer[4];
        completerArray[0] = NullCompleter.INSTANCE;
        completerArray[1] = new StringsCompleter(this.aliases::keySet);
        completerArray[2] = new AliasValueCompleter(this.aliases);
        completerArray[3] = NullCompleter.INSTANCE;
        completers.add((Completer)new ArgumentCompleter(completerArray));
        return completers;
    }

    private List<Completer> unaliasCompleter(String command) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        Completer[] completerArray = new Completer[2];
        completerArray[0] = NullCompleter.INSTANCE;
        completerArray[1] = new StringsCompleter(this.aliases::keySet);
        completers.add((Completer)new ArgumentCompleter(completerArray));
        return completers;
    }

    private List<Completer> pipeCompleter(String command) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add((Completer)new ArgumentCompleter(new Completer[]{NullCompleter.INSTANCE, new Completers.OptionCompleter((Completer)NullCompleter.INSTANCE, this::commandOptions, 1)}));
        return completers;
    }

    private static class AliasValueCompleter
    implements Completer {
        private final Map<String, String> aliases;

        public AliasValueCompleter(Map<String, String> aliases) {
            this.aliases = aliases;
        }

        public void complete(LineReader reader, ParsedLine commandLine, List<Candidate> candidates) {
            String h;
            assert (commandLine != null);
            assert (candidates != null);
            List words = commandLine.words();
            if (words.size() > 1 && (h = (String)words.get(words.size() - 2)) != null && h.length() > 0 && this.aliases.containsKey(h)) {
                String v = this.aliases.get(h);
                candidates.add(new Candidate(AttributedString.stripAnsi((String)v), v, null, null, null, null, true));
            }
        }
    }

    private class ScriptFile {
        private File script;
        private String extension = "";
        private String cmdLine;
        private String[] args;
        private boolean verbose;
        private Object result;

        public ScriptFile(String command, String cmdLine, String[] args) {
            if (!ConsoleEngineImpl.this.parser().validCommandName(command)) {
                return;
            }
            try {
                this.script = new File(command);
                this.cmdLine = cmdLine;
                if (this.script.exists()) {
                    this.scriptExtension(command);
                } else if (ConsoleEngineImpl.this.engine.hasVariable(ConsoleEngineImpl.VAR_PATH)) {
                    boolean found = false;
                    for (String p : (List)ConsoleEngineImpl.this.engine.get(ConsoleEngineImpl.VAR_PATH)) {
                        for (String e : ConsoleEngineImpl.this.scriptExtensions()) {
                            String file = command + "." + e;
                            Path path = Paths.get(p, file);
                            if (!path.toFile().exists()) continue;
                            this.script = path.toFile();
                            this.scriptExtension(command);
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        break;
                    }
                }
                this.doArgs(args);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public ScriptFile(File script, String cmdLine, String[] args) {
            if (!script.exists()) {
                throw new IllegalArgumentException("Script file not found!");
            }
            this.script = script;
            this.cmdLine = cmdLine;
            this.scriptExtension(script.getName());
            this.doArgs(args);
        }

        private void scriptExtension(String command) {
            String name = this.script.getName();
            String string = this.extension = name.contains(".") ? name.substring(name.lastIndexOf(".") + 1) : "";
            if (!this.isEngineScript() && !this.isConsoleScript()) {
                throw new IllegalArgumentException("Command not found: " + command);
            }
        }

        private void doArgs(String[] args) {
            ArrayList<String> _args = new ArrayList<String>();
            if (this.isConsoleScript()) {
                _args.add(this.script.getAbsolutePath());
            }
            for (String a : args) {
                if (this.isConsoleScript()) {
                    if (!a.equals(ConsoleEngineImpl.OPTION_VERBOSE)) {
                        _args.add(a);
                        continue;
                    }
                    this.verbose = true;
                    continue;
                }
                _args.add(a);
            }
            this.args = _args.toArray(new String[0]);
        }

        private boolean isEngineScript() {
            return ConsoleEngineImpl.this.engine.getExtensions().contains(this.extension);
        }

        private boolean isConsoleScript() {
            return ConsoleEngineImpl.this.scriptExtension.equals(this.extension);
        }

        private boolean isScript() {
            return ConsoleEngineImpl.this.engine.getExtensions().contains(this.extension) || ConsoleEngineImpl.this.scriptExtension.equals(this.extension);
        }

        public boolean execute() throws Exception {
            if (!this.isScript()) {
                return false;
            }
            this.result = null;
            if (Arrays.asList(this.args).contains(OPTION_HELP[0]) || Arrays.asList(this.args).contains(OPTION_HELP[1])) {
                try (BufferedReader br = new BufferedReader(new FileReader(this.script));){
                    String l;
                    int size = 0;
                    StringBuilder usage = new StringBuilder();
                    boolean helpEnd = false;
                    boolean headComment = false;
                    while ((l = br.readLine()) != null) {
                        String line = l = l.replaceAll("\\s+$", "");
                        if (++size > 30 || line.endsWith(ConsoleEngineImpl.END_HELP)) {
                            helpEnd = line.endsWith(ConsoleEngineImpl.END_HELP);
                            break;
                        }
                        if (headComment || size < 3) {
                            String ltr = l.trim();
                            if (ltr.startsWith("*") || ltr.startsWith("#")) {
                                headComment = true;
                                line = ltr.length() > 1 ? ltr.substring(2) : "";
                            } else if (ltr.startsWith("/*") || ltr.startsWith("//")) {
                                headComment = true;
                                line = ltr.length() > 2 ? ltr.substring(3) : "";
                            }
                        }
                        usage.append(line).append('\n');
                    }
                    if (usage.length() > 0) {
                        usage.append("\n");
                        if (!helpEnd) {
                            usage.insert(0, "\n");
                        }
                        throw new Options.HelpException(usage.toString());
                    }
                    this.internalExecute();
                }
            } else {
                this.internalExecute();
            }
            return true;
        }

        private void internalExecute() throws Exception {
            if (this.isEngineScript()) {
                this.result = ConsoleEngineImpl.this.engine.execute(this.script, ConsoleEngineImpl.this.expandParameters(this.args));
            } else if (this.isConsoleScript()) {
                ConsoleEngineImpl.this.executing = true;
                boolean done = true;
                String line = "";
                try (BufferedReader br = new BufferedReader(new FileReader(this.script));){
                    String l;
                    while ((l = br.readLine()) != null) {
                        if (l.trim().isEmpty() || l.trim().startsWith("#")) {
                            done = true;
                            continue;
                        }
                        try {
                            line = line + l;
                            done = false;
                            ConsoleEngineImpl.this.parser().parse(line, line.length() + 1, Parser.ParseContext.ACCEPT_LINE);
                            done = true;
                            for (int i = 1; i < this.args.length; ++i) {
                                line = line.replaceAll("\\s\\$" + i + "\\b", this.args[i].startsWith("$") ? " " + ConsoleEngineImpl.this.expandName(this.args[i]) + " " : " " + ConsoleEngineImpl.this.quote(this.args[i]) + " ");
                                line = line.replaceAll("\\$\\{" + i + "(|:-.*)\\}", this.args[i].startsWith("$") ? ConsoleEngineImpl.this.expandName(this.args[i]) : ConsoleEngineImpl.this.quote(this.args[i]));
                            }
                            line = line.replaceAll("\\s\\$\\d\\b", "");
                            line = line.replaceAll("\\$\\{\\d+\\}", "");
                            Matcher matcher = Pattern.compile("\\$\\{\\d+:-(.*?)\\}").matcher(line);
                            if (matcher.find()) {
                                line = matcher.replaceAll("'$1'");
                            }
                            if (this.verbose) {
                                AttributedStringBuilder asb = new AttributedStringBuilder();
                                asb.append((CharSequence)line, AttributedStyle.DEFAULT.foreground(2));
                                asb.toAttributedString().println(ConsoleEngineImpl.this.terminal());
                                ConsoleEngineImpl.this.terminal().flush();
                            }
                            ConsoleEngineImpl.this.println(ConsoleEngineImpl.this.systemRegistry.execute(line));
                            line = "";
                        }
                        catch (EOFError e) {
                            done = false;
                            line = line + "\n";
                        }
                        catch (SyntaxError e) {
                            throw e;
                        }
                        catch (EndOfFileException e) {
                            done = true;
                            this.result = ConsoleEngineImpl.this.engine.get("_return");
                            ConsoleEngineImpl.this.postProcess(this.cmdLine, this.result);
                            break;
                        }
                        catch (Exception e) {
                            ConsoleEngineImpl.this.executing = false;
                            throw new IllegalArgumentException(line + "\n" + e.getMessage());
                        }
                    }
                    if (!done) {
                        ConsoleEngineImpl.this.executing = false;
                        throw new IllegalArgumentException("Incompleted command: \n" + line);
                    }
                    ConsoleEngineImpl.this.executing = false;
                }
            }
        }

        public Object getResult() {
            return this.result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            try {
                sb.append("script:").append(this.script.getCanonicalPath());
            }
            catch (Exception e) {
                sb.append(e.getMessage());
            }
            sb.append(", ");
            sb.append("extension:").append(this.extension);
            sb.append(", ");
            sb.append("cmdLine:").append(this.cmdLine);
            sb.append(", ");
            sb.append("args:").append(Arrays.asList(this.args));
            sb.append(", ");
            sb.append("verbose:").append(this.verbose);
            sb.append(", ");
            sb.append("result:").append(this.result);
            sb.append("]");
            return sb.toString();
        }
    }

    public static enum Command {
        SHOW,
        DEL,
        PRNT,
        ALIAS,
        PIPE,
        UNALIAS,
        SLURP;

    }
}

