/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jline.builtins.Builtins;
import org.jline.builtins.CommandRegistry;
import org.jline.builtins.Completers;
import org.jline.builtins.ConsoleEngine;
import org.jline.builtins.ConsoleEngineImpl;
import org.jline.builtins.Options;
import org.jline.builtins.SystemRegistry;
import org.jline.builtins.Widgets;
import org.jline.keymap.KeyMap;
import org.jline.reader.Completer;
import org.jline.reader.ConfigurationPath;
import org.jline.reader.EndOfFileException;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.impl.completer.AggregateCompleter;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.terminal.Attributes;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.OSUtils;

public class SystemRegistryImpl
implements SystemRegistry {
    private static final Class<?>[] BUILTIN_REGISTERIES = new Class[]{Builtins.class, ConsoleEngineImpl.class};
    private CommandRegistry[] commandRegistries;
    private Integer consoleId = null;
    private Parser parser;
    private ConfigurationPath configPath;
    private Map<Command, String> commandName = new HashMap<Command, String>();
    private Map<String, Command> nameCommand = new HashMap<String, Command>();
    private Map<String, String> aliasCommand = new HashMap<String, String>();
    private Map<Pipe, String> pipeName = new HashMap<Pipe, String>();
    private final Map<Command, Builtins.CommandMethods> commandExecute = new HashMap<Command, Builtins.CommandMethods>();
    private Map<String, List<String>> commandInfos = new HashMap<String, List<String>>();
    private Exception exception;
    private CommandOutputStream outputStream;
    private ScriptStore scriptStore = new ScriptStore();

    public SystemRegistryImpl(Parser parser, Terminal terminal, ConfigurationPath configPath) {
        this.parser = parser;
        this.configPath = configPath;
        this.outputStream = new CommandOutputStream(terminal);
        HashSet<Command> cmds = new HashSet<Command>(EnumSet.allOf(Command.class));
        for (Command c : cmds) {
            this.commandName.put(c, c.name().toLowerCase());
        }
        this.doNameCommand();
        this.pipeName.put(Pipe.FLIP, "|;");
        this.pipeName.put(Pipe.NAMED, "|");
        this.pipeName.put(Pipe.AND, "&&");
        this.pipeName.put(Pipe.OR, "||");
        this.commandExecute.put(Command.EXIT, new Builtins.CommandMethods(this::exit, this::exitCompleter));
        this.commandExecute.put(Command.HELP, new Builtins.CommandMethods(this::help, this::helpCompleter));
    }

    private void doNameCommand() {
        this.nameCommand = this.commandName.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    public void rename(Pipe pipe, String name) {
        if (name.matches("/w+") || this.pipeName.containsValue(name)) {
            throw new IllegalArgumentException();
        }
        this.pipeName.put(pipe, name);
    }

    @Override
    public Collection<String> getPipeNames() {
        return this.pipeName.values();
    }

    @Override
    public void setCommandRegistries(CommandRegistry ... commandRegistries) {
        this.commandRegistries = commandRegistries;
        for (int i = 0; i < commandRegistries.length; ++i) {
            if (commandRegistries[i] instanceof ConsoleEngine) {
                if (this.consoleId != null) {
                    throw new IllegalArgumentException();
                }
                this.consoleId = i;
                ((ConsoleEngine)commandRegistries[i]).setSystemRegistry(this);
                this.scriptStore = new ScriptStore((ConsoleEngine)commandRegistries[i]);
                continue;
            }
            if (!(commandRegistries[i] instanceof SystemRegistry)) continue;
            throw new IllegalArgumentException();
        }
        SystemRegistry.add(this);
    }

    @Override
    public void initialize(File script) {
        if (this.consoleId != null) {
            try {
                this.consoleEngine().execute(script);
            }
            catch (Exception e) {
                this.trace(e);
            }
        }
    }

    @Override
    public Set<String> commandNames() {
        HashSet<String> out = new HashSet<String>();
        for (CommandRegistry r : this.commandRegistries) {
            out.addAll(r.commandNames());
        }
        out.addAll(this.localCommandNames());
        return out;
    }

    private Set<String> localCommandNames() {
        return this.nameCommand.keySet();
    }

    @Override
    public Map<String, String> commandAliases() {
        HashMap<String, String> out = new HashMap<String, String>();
        for (CommandRegistry r : this.commandRegistries) {
            out.putAll(r.commandAliases());
        }
        out.putAll(this.aliasCommand);
        return out;
    }

    private Command command(String name) {
        Command out = null;
        if (!this.isLocalCommand(name)) {
            throw new IllegalArgumentException("Command does not exists!");
        }
        if (this.aliasCommand.containsKey(name)) {
            name = this.aliasCommand.get(name);
        }
        if (!this.nameCommand.containsKey(name)) {
            throw new IllegalArgumentException("Command does not exists!");
        }
        out = this.nameCommand.get(name);
        return out;
    }

    private List<String> localCommandInfo(String command) {
        try {
            this.localExecute(command, new String[]{"--help"});
        }
        catch (Options.HelpException e) {
            this.exception = null;
            return Builtins.compileCommandInfo(e.getMessage());
        }
        catch (Exception e) {
            this.trace(e);
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> commandInfo(String command) {
        int id = this.registryId(command);
        List<Object> out = new ArrayList();
        if (id > -1) {
            if (!this.commandInfos.containsKey(command)) {
                this.commandInfos.put(command, this.commandRegistries[id].commandInfo(command));
            }
            out = this.commandInfos.get(command);
        } else if (this.scriptStore.hasScript(command)) {
            out = this.consoleEngine().commandInfo(command);
        } else if (this.isLocalCommand(command)) {
            out = this.localCommandInfo(command);
        }
        return out;
    }

    @Override
    public boolean hasCommand(String command) {
        return this.registryId(command) > -1 || this.isLocalCommand(command);
    }

    private boolean isLocalCommand(String command) {
        return this.nameCommand.containsKey(command) || this.aliasCommand.containsKey(command);
    }

    private boolean isCommandOrScript(String command) {
        if (this.hasCommand(command)) {
            return true;
        }
        return this.scriptStore.hasScript(command);
    }

    @Override
    public Completers.SystemCompleter compileCompleters() {
        Completers.SystemCompleter out = CommandRegistry.aggregateCompleters(this.commandRegistries);
        Completers.SystemCompleter local = new Completers.SystemCompleter();
        for (Map.Entry<Command, String> entry : this.commandName.entrySet()) {
            local.add(entry.getValue(), this.commandExecute.get((Object)entry.getKey()).compileCompleter().apply(entry.getValue()));
        }
        local.addAliases(this.aliasCommand);
        out.add(local);
        out.compile();
        return out;
    }

    @Override
    public Completer completer() {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add(this.compileCompleters());
        if (this.consoleId > -1) {
            completers.addAll(this.consoleEngine().scriptCompleters());
        }
        return new AggregateCompleter(completers);
    }

    private Widgets.CmdDesc localCommandDescription(String command) {
        if (!this.isLocalCommand(command)) {
            throw new IllegalArgumentException();
        }
        try {
            this.localExecute(command, new String[]{"--help"});
        }
        catch (Options.HelpException e) {
            this.exception = null;
            return Builtins.compileCommandDescription(e.getMessage());
        }
        catch (Exception e) {
            this.trace(e);
        }
        return null;
    }

    @Override
    public Widgets.CmdDesc commandDescription(String command) {
        Widgets.CmdDesc out = new Widgets.CmdDesc(false);
        int id = this.registryId(command);
        if (id > -1) {
            out = this.commandRegistries[id].commandDescription(command);
        } else if (this.scriptStore.hasScript(command)) {
            out = this.consoleEngine().commandDescription(command);
        } else if (this.isLocalCommand(command)) {
            out = this.localCommandDescription(command);
        }
        return out;
    }

    @Override
    public Widgets.CmdDesc commandDescription(Widgets.CmdLine line) {
        Widgets.CmdDesc out = null;
        switch (line.getDescriptionType()) {
            case COMMAND: {
                String cmd = this.parser.getCommand(line.getArgs().get(0));
                if (!this.isCommandOrScript(cmd) || this.hasPipes(line.getArgs())) break;
                out = this.commandDescription(cmd);
                break;
            }
        }
        return out;
    }

    @Override
    public Object invoke(String command, Object ... args) throws Exception {
        Object out = null;
        int id = this.registryId(command = ConsoleEngine.plainCommand(command));
        if (id > -1) {
            out = this.commandRegistries[id].invoke(this.commandSession(), command, args);
        } else if (this.isLocalCommand(command)) {
            String[] _args = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof String)) {
                    throw new IllegalArgumentException();
                }
                _args[i] = args[i].toString();
            }
            out = this.localExecute(command, _args);
        } else if (this.consoleId != null) {
            out = this.consoleEngine().invoke(this.commandSession(), command, args);
        }
        return out;
    }

    @Override
    public Object execute(String command, String[] args) throws Exception {
        Object out = null;
        int id = this.registryId(command);
        if (id > -1) {
            out = this.commandRegistries[id].execute(this.commandSession(), command, args);
        } else if (this.isLocalCommand(command)) {
            out = this.localExecute(command, args);
        }
        return out;
    }

    public Object localExecute(String command, String[] args) throws Exception {
        if (!this.isLocalCommand(command)) {
            throw new IllegalArgumentException();
        }
        Object out = this.commandExecute.get((Object)this.command(command)).executeFunction().apply(new Builtins.CommandInput(args, this.commandSession()));
        if (this.exception != null) {
            throw this.exception;
        }
        return out;
    }

    @Override
    public Terminal terminal() {
        return this.commandSession().terminal();
    }

    private CommandRegistry.CommandSession commandSession() {
        return this.outputStream.getCommandSession();
    }

    private boolean isPipe(String arg) {
        Map<Object, Object> customPipes = this.consoleId != null ? this.consoleEngine().getPipes() : new HashMap();
        return this.isPipe(arg, customPipes.keySet());
    }

    private boolean hasPipes(Collection<String> args) {
        Map<Object, Object> customPipes = this.consoleId != null ? this.consoleEngine().getPipes() : new HashMap();
        for (String a : args) {
            if (!this.isPipe(a, customPipes.keySet()) && !a.contains(">") && !a.contains(">>")) continue;
            return true;
        }
        return false;
    }

    private boolean isPipe(String arg, Set<String> pipes) {
        return this.pipeName.containsValue(arg) || pipes.contains(arg);
    }

    private boolean isCommandAlias(String command) {
        if (this.consoleId == null || !this.parser.validCommandName(command) || !this.consoleEngine().hasAlias(command)) {
            return false;
        }
        String value = this.consoleEngine().getAlias(command).split("\\s+")[0];
        return !this.isPipe(value);
    }

    private String replaceCommandAlias(String variable, String command, String rawLine) {
        return variable == null ? rawLine.replaceFirst(command + "(\\b|$)", this.consoleEngine().getAlias(command)) : rawLine.replaceFirst("=" + command + "(\\b|$)", "=" + this.consoleEngine().getAlias(command));
    }

    private List<CommandData> compileCommandLine(String commandLine) {
        Map<Object, Object> customPipes;
        ArrayList<CommandData> out = new ArrayList<CommandData>();
        ArgsParser ap = new ArgsParser();
        ap.parse(this.parser, commandLine);
        List<String> ws = ap.args();
        Map<Object, Object> map = customPipes = this.consoleId != null ? this.consoleEngine().getPipes() : new HashMap();
        if (this.consoleId != null && ws.contains(this.pipeName.get((Object)Pipe.NAMED))) {
            StringBuilder sb = new StringBuilder();
            boolean trace = false;
            for (int i = 0; i < ws.size(); ++i) {
                if (ws.get(i).equals(this.pipeName.get((Object)Pipe.NAMED))) {
                    if (i + 1 < ws.size() && this.consoleEngine().hasAlias(ws.get(i + 1))) {
                        trace = true;
                        ArrayList<String> args = new ArrayList<String>();
                        String pipeAlias = this.consoleEngine().getAlias(ws.get(++i));
                        while (i < ws.size() - 1 && !this.isPipe(ws.get(i + 1), customPipes.keySet())) {
                            args.add(ws.get(++i));
                        }
                        for (int j = 0; j < args.size(); ++j) {
                            pipeAlias = pipeAlias.replaceAll("\\s\\$" + j + "\\b", " " + (String)args.get(j));
                            pipeAlias = pipeAlias.replaceAll("\\$\\{" + j + "(|:-.*)\\}", (String)args.get(j));
                        }
                        pipeAlias = pipeAlias.replaceAll("\\s+\\$\\d\\b", "");
                        pipeAlias = pipeAlias.replaceAll("\\s+\\$\\{\\d+\\}", "");
                        pipeAlias = pipeAlias.replaceAll("\\$\\{\\d+\\}", "");
                        Matcher matcher = Pattern.compile("\\$\\{\\d+:-(.*?)\\}").matcher(pipeAlias);
                        if (matcher.find()) {
                            pipeAlias = matcher.replaceAll("$1");
                        }
                        sb.append(pipeAlias);
                    } else {
                        sb.append(ws.get(i));
                    }
                } else {
                    sb.append(ws.get(i));
                }
                sb.append(" ");
            }
            ap.parse(this.parser, sb.toString());
            if (trace) {
                this.consoleEngine().trace(ap.line());
            }
        }
        List<String> words = ap.args();
        String nextRawLine = ap.line();
        int first = 0;
        int last = words.size();
        ArrayList<String> pipes = new ArrayList<String>();
        String pipeSource = null;
        String rawLine = null;
        String pipeResult = null;
        if (!this.hasPipes(words)) {
            if (this.isCommandAlias(ap.command())) {
                nextRawLine = this.replaceCommandAlias(ap.variable(), ap.command(), nextRawLine);
            }
            out.add(new CommandData(this.parser, false, nextRawLine, ap.variable(), null, false, ""));
        } else {
            do {
                String subLine;
                String command = ConsoleEngine.plainCommand(this.parser.getCommand(words.get(first)));
                String variable = this.parser.getVariable(words.get(first));
                if (this.isCommandAlias(command)) {
                    ap.parse(this.parser, this.replaceCommandAlias(variable, command, nextRawLine));
                    command = ap.command();
                    words = ap.args();
                    first = 0;
                }
                if (this.scriptStore.isConsoleScript(command)) {
                    throw new IllegalArgumentException("Console scripts cannot be used in pipe!");
                }
                last = words.size();
                File file = null;
                boolean append = false;
                boolean pipeStart = false;
                boolean skipPipe = false;
                ArrayList<String> _words = new ArrayList<String>();
                for (int i = first; i < last; ++i) {
                    if (words.get(i).equals(">") || words.get(i).equals(">>")) {
                        pipes.add(words.get(i));
                        append = words.get(i).equals(">>");
                        if (i + 1 >= last) {
                            throw new IllegalArgumentException();
                        }
                        file = new File(words.get(i + 1));
                        last = i + 1;
                        break;
                    }
                    if (words.get(i).equals(this.pipeName.get((Object)Pipe.FLIP))) {
                        if (variable != null || file != null || pipeResult != null || this.consoleId == null) {
                            throw new IllegalArgumentException();
                        }
                        pipes.add(words.get(i));
                        last = i;
                        variable = "_pipe" + (pipes.size() - 1);
                        break;
                    }
                    if (words.get(i).equals(this.pipeName.get((Object)Pipe.NAMED)) || words.get(i).matches("^.*[^a-zA-Z0-9 ].*$") && customPipes.containsKey(words.get(i))) {
                        String pipe = words.get(i);
                        if (pipe.equals(this.pipeName.get((Object)Pipe.NAMED))) {
                            if (i + 1 >= last) {
                                throw new IllegalArgumentException("Pipe is NULL!");
                            }
                            pipe = words.get(i + 1);
                            if (!pipe.matches("\\w+") || !customPipes.containsKey(pipe)) {
                                throw new IllegalArgumentException("Unknown or illegal pipe name: " + pipe);
                            }
                        }
                        pipes.add(pipe);
                        last = i;
                        if (pipeSource != null) break;
                        pipeSource = "_pipe" + (pipes.size() - 1);
                        pipeResult = variable;
                        variable = pipeSource;
                        pipeStart = true;
                        break;
                    }
                    if (words.get(i).equals(this.pipeName.get((Object)Pipe.OR)) || words.get(i).equals(this.pipeName.get((Object)Pipe.AND))) {
                        if (variable != null || pipeSource != null) {
                            pipes.add(words.get(i));
                        } else if (pipes.size() > 0 && (((String)pipes.get(pipes.size() - 1)).equals(">") || ((String)pipes.get(pipes.size() - 1)).equals(">>"))) {
                            pipes.remove(pipes.size() - 1);
                            ((CommandData)out.get(out.size() - 1)).setPipe(words.get(i));
                            skipPipe = true;
                        } else {
                            pipes.add(words.get(i));
                            pipeSource = "_pipe" + (pipes.size() - 1);
                            pipeResult = variable;
                            variable = pipeSource;
                            pipeStart = true;
                        }
                        last = i;
                        break;
                    }
                    _words.add(words.get(i));
                }
                if (last == words.size()) {
                    pipes.add("END_PIPE");
                } else if (skipPipe) {
                    first = last + 1;
                    continue;
                }
                String string = subLine = last < words.size() || first > 0 ? _words.stream().collect(Collectors.joining(" ")) : ap.line();
                if (last + 1 < words.size()) {
                    nextRawLine = words.subList(last + 1, words.size()).stream().collect(Collectors.joining(" "));
                }
                boolean done = true;
                boolean statement = false;
                ArrayList<String> arglist = new ArrayList<String>();
                if (_words.size() > 0) {
                    arglist.addAll(_words.subList(1, _words.size()));
                }
                if (rawLine != null || pipes.size() > 1 && customPipes.containsKey(pipes.get(pipes.size() - 2))) {
                    done = false;
                    if (rawLine == null) {
                        rawLine = pipeSource;
                    }
                    if (customPipes.containsKey(pipes.get(pipes.size() - 2))) {
                        List fixes = (List)customPipes.get(pipes.get(pipes.size() - 2));
                        if (((String)pipes.get(pipes.size() - 2)).matches("\\w+")) {
                            int idx = subLine.indexOf(" ");
                            subLine = idx > 0 ? subLine.substring(idx + 1) : "";
                        }
                        rawLine = rawLine + (String)fixes.get(0) + subLine + (String)fixes.get(1);
                        statement = true;
                    }
                    if (((String)pipes.get(pipes.size() - 1)).equals(this.pipeName.get((Object)Pipe.FLIP)) || ((String)pipes.get(pipes.size() - 1)).equals(this.pipeName.get((Object)Pipe.AND)) || ((String)pipes.get(pipes.size() - 1)).equals(this.pipeName.get((Object)Pipe.OR))) {
                        done = true;
                        pipeSource = null;
                        if (variable != null) {
                            rawLine = variable + " = " + rawLine;
                        }
                    }
                    if (last + 1 >= words.size() || file != null) {
                        done = true;
                        pipeSource = null;
                        if (pipeResult != null) {
                            rawLine = pipeResult + " = " + rawLine;
                        }
                    }
                } else if (((String)pipes.get(pipes.size() - 1)).equals(this.pipeName.get((Object)Pipe.FLIP)) || pipeStart) {
                    if (pipeStart && pipeResult != null) {
                        subLine = subLine.substring(subLine.indexOf("=") + 1);
                    }
                    rawLine = this.flipArgument(command, subLine, pipes, arglist);
                    rawLine = variable + "=" + rawLine;
                } else {
                    rawLine = this.flipArgument(command, subLine, pipes, arglist);
                }
                if (done) {
                    out.add(new CommandData(this.parser, statement, rawLine, variable, file, append, (String)pipes.get(pipes.size() - 1)));
                    if (((String)pipes.get(pipes.size() - 1)).equals(this.pipeName.get((Object)Pipe.AND)) || ((String)pipes.get(pipes.size() - 1)).equals(this.pipeName.get((Object)Pipe.OR))) {
                        pipeSource = null;
                        pipeResult = null;
                    }
                    rawLine = null;
                }
                first = last + 1;
            } while (first < words.size());
        }
        return out;
    }

    private String flipArgument(String command, String subLine, List<String> pipes, List<String> arglist) {
        String out = null;
        if (pipes.size() > 1 && pipes.get(pipes.size() - 2).equals(this.pipeName.get((Object)Pipe.FLIP))) {
            String s = this.isCommandOrScript(command) ? "$" : "";
            out = subLine + " " + s + "_pipe" + (pipes.size() - 2);
            if (!command.isEmpty()) {
                arglist.add(s + "_pipe" + (pipes.size() - 2));
            }
        } else {
            out = subLine;
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Object execute(String line) throws Exception {
        if (line.isEmpty() || line.trim().startsWith("#")) {
            return null;
        }
        Object out = null;
        boolean statement = false;
        boolean postProcessed = false;
        this.scriptStore.refresh();
        List<CommandData> cmds = this.compileCommandLine(line);
        for (int i = 0; i < cmds.size(); ++i) {
            CommandData cmd = cmds.get(i);
            try {
                this.outputStream.closeAndReset();
                if (!this.consoleEngine().isExecuting()) {
                    this.trace(cmd);
                }
                this.exception = null;
                statement = false;
                postProcessed = false;
                if (!(cmd.variable() == null && cmd.file() == null || this.scriptStore.isConsoleScript(cmd.command()))) {
                    if (cmd.file() != null) {
                        this.outputStream.redirect(cmd.file(), cmd.append());
                    } else if (this.consoleId != null) {
                        this.outputStream.redirect();
                    }
                    this.outputStream.open();
                }
                boolean consoleScript = false;
                if (this.parser.validCommandName(cmd.command())) {
                    if (this.isLocalCommand(cmd.command())) {
                        out = this.localExecute(cmd.command(), cmd.args());
                    } else {
                        int id = this.registryId(cmd.command());
                        if (id > -1) {
                            out = this.consoleId != null ? this.commandRegistries[id].invoke(this.outputStream.getCommandSession(), cmd.command(), this.consoleEngine().expandParameters(cmd.args())) : this.commandRegistries[id].execute(this.outputStream.getCommandSession(), cmd.command(), cmd.args());
                        } else {
                            consoleScript = true;
                        }
                    }
                } else {
                    consoleScript = true;
                }
                if (this.consoleId != null) {
                    if (consoleScript) {
                        if (cmd.command().isEmpty() || !this.scriptStore.hasScript(cmd.command())) {
                            statement = true;
                        }
                        if (statement && this.outputStream.isByteStream()) {
                            this.outputStream.closeAndReset();
                        }
                        out = this.consoleEngine().execute(cmd.command(), cmd.rawLine(), cmd.args());
                    }
                    if (cmd.pipe().equals(this.pipeName.get((Object)Pipe.OR)) || cmd.pipe().equals(this.pipeName.get((Object)Pipe.AND))) {
                        boolean success;
                        ConsoleEngine.ExecutionResult er = this.postProcess(cmd, statement, out);
                        postProcessed = true;
                        this.consoleEngine().println(er.result());
                        out = null;
                        boolean bl = success = er.status() == 0;
                        if (cmd.pipe().equals(this.pipeName.get((Object)Pipe.OR)) && success || cmd.pipe().equals(this.pipeName.get((Object)Pipe.AND)) && !success) {
                            if (postProcessed || this.consoleId == null) break;
                            out = this.postProcess(cmd, statement, out).result();
                            break;
                        }
                    }
                }
                if (postProcessed || this.consoleId == null) continue;
                out = this.postProcess(cmd, statement, out).result();
                continue;
            }
            catch (Options.HelpException e) {
                this.trace(e);
                if (postProcessed || this.consoleId == null) continue;
                out = this.postProcess(cmd, statement, out).result();
                continue;
            }
            catch (Exception e2) {
                if (!cmd.pipe().equals(this.pipeName.get((Object)Pipe.OR))) {
                    throw e2;
                }
                this.trace(e2);
                postProcessed = true;
                if (postProcessed || this.consoleId == null) continue;
                out = this.postProcess(cmd, statement, out).result();
                continue;
                {
                    catch (Throwable throwable) {
                        if (!postProcessed && this.consoleId != null) {
                            out = this.postProcess(cmd, statement, out).result();
                        }
                        throw throwable;
                    }
                }
            }
        }
        return out;
    }

    private ConsoleEngine.ExecutionResult postProcess(CommandData cmd, boolean statement, Object result) {
        ConsoleEngine.ExecutionResult out = new ConsoleEngine.ExecutionResult(result != null ? 0 : 1, result);
        if (cmd.file() != null) {
            int status = 1;
            if (cmd.file().exists()) {
                long delta = new Date().getTime() - cmd.file().lastModified();
                status = delta < 100L ? 0 : 1;
            }
            out = new ConsoleEngine.ExecutionResult(status, result);
        } else if (!statement) {
            this.outputStream.flush();
            this.outputStream.close();
            out = this.consoleEngine().postProcess(cmd.rawLine(), result, this.outputStream.getOutput());
            this.outputStream.reset();
        } else if (cmd.variable() != null) {
            out = this.consoleEngine().hasVariable(cmd.variable()) ? this.consoleEngine().postProcess(this.consoleEngine().getVariable(cmd.variable())) : this.consoleEngine().postProcess(result);
            if (!cmd.variable().startsWith("_")) {
                out = new ConsoleEngine.ExecutionResult(out.status(), null);
            }
        } else {
            out = this.consoleEngine().postProcess(result);
        }
        return out;
    }

    @Override
    public void cleanUp() {
        if (this.outputStream.isRedirecting()) {
            this.outputStream.closeAndReset();
        }
        if (this.consoleId != null) {
            this.consoleEngine().purge();
        }
    }

    private void trace(CommandData commandData) {
        if (this.consoleId != null) {
            this.consoleEngine().trace(commandData);
        } else {
            AttributedStringBuilder asb = new AttributedStringBuilder();
            asb.append((CharSequence)commandData.rawLine(), AttributedStyle.DEFAULT.foreground(3)).println(this.terminal());
        }
    }

    @Override
    public void trace(Exception exception) {
        if (this.outputStream.isRedirecting()) {
            this.outputStream.closeAndReset();
        }
        if (this.consoleId != null) {
            this.consoleEngine().putVariable("exception", exception);
            this.consoleEngine().trace(exception);
        } else {
            this.trace(false, exception);
        }
    }

    @Override
    public void trace(boolean stack, Exception exception) {
        if (exception instanceof Options.HelpException) {
            Options.HelpException.highlight(exception.getMessage(), Options.HelpException.defaultStyle()).print(this.terminal());
        } else if (stack) {
            exception.printStackTrace();
        } else {
            String message = exception.getMessage();
            AttributedStringBuilder asb = new AttributedStringBuilder();
            if (message != null) {
                asb.append((CharSequence)message, AttributedStyle.DEFAULT.foreground(1));
            } else {
                asb.append((CharSequence)"Caught exception: ", AttributedStyle.DEFAULT.foreground(1));
                asb.append((CharSequence)exception.getClass().getCanonicalName(), AttributedStyle.DEFAULT.foreground(1));
            }
            asb.toAttributedString().println(this.terminal());
        }
    }

    private ConsoleEngine consoleEngine() {
        return this.consoleId != null ? (ConsoleEngine)this.commandRegistries[this.consoleId] : null;
    }

    private boolean isBuiltinRegistry(CommandRegistry registry) {
        for (Class<?> c : BUILTIN_REGISTERIES) {
            if (c != registry.getClass()) continue;
            return true;
        }
        return false;
    }

    private void printHeader(String header) {
        AttributedStringBuilder asb = new AttributedStringBuilder().tabs(2);
        asb.append((CharSequence)"\t");
        asb.append((CharSequence)header, Options.HelpException.defaultStyle().resolve(".ti"));
        asb.append((CharSequence)":");
        asb.toAttributedString().println(this.terminal());
    }

    private void printCommandInfo(String command, String info, int max) {
        AttributedStringBuilder asb = new AttributedStringBuilder().tabs(Arrays.asList(4, max + 4));
        asb.append((CharSequence)"\t");
        asb.append((CharSequence)command, Options.HelpException.defaultStyle().resolve(".co"));
        asb.append((CharSequence)"\t");
        asb.append((CharSequence)info);
        asb.setLength(this.terminal().getWidth());
        asb.toAttributedString().println(this.terminal());
    }

    private void printCommands(Collection<String> commands, int max) {
        AttributedStringBuilder asb = new AttributedStringBuilder().tabs(Arrays.asList(4, max + 4));
        int col = 0;
        asb.append((CharSequence)"\t");
        col += 4;
        boolean done = false;
        for (String c : commands) {
            asb.append((CharSequence)c, Options.HelpException.defaultStyle().resolve(".co"));
            asb.append((CharSequence)"\t");
            if ((col += max) + max > this.terminal().getWidth()) {
                asb.toAttributedString().println(this.terminal());
                asb = new AttributedStringBuilder().tabs(Arrays.asList(4, max + 4));
                col = 0;
                asb.append((CharSequence)"\t");
                col += 4;
                done = true;
                continue;
            }
            done = false;
        }
        if (!done) {
            asb.toAttributedString().println(this.terminal());
        }
        this.terminal().flush();
    }

    private String doCommandInfo(List<String> info) {
        return info.size() > 0 ? info.get(0) : " ";
    }

    private boolean isInArgs(List<String> args, String name) {
        return args.isEmpty() || args.contains(name);
    }

    private Object help(Builtins.CommandInput input) {
        String[] usage = new String[]{"help -  command help", "Usage: help [TOPIC...]", "  -? --help                       Displays command help"};
        Options opt = Options.compile(usage).parse(input.args());
        if (opt.isSet("help")) {
            this.exception = new Options.HelpException(opt.usage());
            return null;
        }
        Set<String> commands = this.commandNames();
        commands.addAll(this.scriptStore.getScripts());
        boolean withInfo = commands.size() < this.terminal().getHeight() || !opt.args().isEmpty();
        int max = Collections.max(commands, Comparator.comparing(String::length)).length() + 1;
        TreeMap<String, String> builtinCommands = new TreeMap<String, String>();
        for (CommandRegistry commandRegistry : this.commandRegistries) {
            if (!this.isBuiltinRegistry(commandRegistry)) continue;
            for (String c : commandRegistry.commandNames()) {
                builtinCommands.put(c, this.doCommandInfo(this.commandInfo(c)));
            }
        }
        for (String string : this.localCommandNames()) {
            builtinCommands.put(string, this.doCommandInfo(this.commandInfo(string)));
            this.exception = null;
        }
        if (this.isInArgs(opt.args(), "Builtins")) {
            this.printHeader("Builtins");
            if (withInfo) {
                for (Map.Entry entry : builtinCommands.entrySet()) {
                    this.printCommandInfo((String)entry.getKey(), (String)entry.getValue(), max);
                }
            } else {
                this.printCommands(builtinCommands.keySet(), max);
            }
        }
        for (CommandRegistry commandRegistry : this.commandRegistries) {
            if (this.isBuiltinRegistry(commandRegistry) || !this.isInArgs(opt.args(), commandRegistry.name())) continue;
            TreeSet<String> cmds = new TreeSet<String>(commandRegistry.commandNames());
            this.printHeader(commandRegistry.name());
            if (withInfo) {
                for (String c : cmds) {
                    this.printCommandInfo(c, this.doCommandInfo(this.commandInfo(c)), max);
                }
                continue;
            }
            this.printCommands(cmds, max);
        }
        if (this.consoleId > -1 && this.isInArgs(opt.args(), "Scripts")) {
            this.printHeader("Scripts");
            if (withInfo) {
                for (String string : this.scriptStore.getScripts()) {
                    this.printCommandInfo(string, this.doCommandInfo(this.commandInfo(string)), max);
                }
            } else {
                this.printCommands(this.scriptStore.getScripts(), max);
            }
        }
        this.terminal().flush();
        return null;
    }

    private Object exit(Builtins.CommandInput input) {
        String[] usage = new String[]{"exit -  exit from app/script", "Usage: exit [OBJECT]", "  -? --help                       Displays command help"};
        Options opt = Options.compile(usage).parse(input.args());
        if (opt.isSet("help")) {
            this.exception = new Options.HelpException(opt.usage());
        } else {
            if (!opt.args().isEmpty() && this.consoleId != null) {
                try {
                    Object[] ret = this.consoleEngine().expandParameters(opt.args().toArray(new String[0]));
                    this.consoleEngine().putVariable("_return", ret.length == 1 ? ret[0] : ret);
                }
                catch (Exception e) {
                    this.trace(e);
                }
            }
            this.exception = new EndOfFileException();
        }
        return null;
    }

    private List<Completers.OptDesc> commandOptions(String command) {
        try {
            this.localExecute(command, new String[]{"--help"});
        }
        catch (Options.HelpException e) {
            this.exception = null;
            return Builtins.compileCommandOptions(e.getMessage());
        }
        catch (Exception e) {
            this.trace(e);
        }
        return null;
    }

    private List<String> registryNames() {
        ArrayList<String> out = new ArrayList<String>();
        out.add("Builtins");
        if (this.consoleId > -1) {
            out.add("Scripts");
        }
        for (CommandRegistry r : this.commandRegistries) {
            if (this.isBuiltinRegistry(r)) continue;
            out.add(r.name());
        }
        return out;
    }

    private List<Completer> helpCompleter(String command) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add((Completer)new ArgumentCompleter(new Completer[]{NullCompleter.INSTANCE, new Completers.OptionCompleter((Completer)new StringsCompleter(this::registryNames), this::commandOptions, 1)}));
        return completers;
    }

    private List<Completer> exitCompleter(String command) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add((Completer)new ArgumentCompleter(new Completer[]{NullCompleter.INSTANCE, new Completers.OptionCompleter((Completer)NullCompleter.INSTANCE, this::commandOptions, 1)}));
        return completers;
    }

    private int registryId(String command) {
        for (int i = 0; i < this.commandRegistries.length; ++i) {
            if (!this.commandRegistries[i].hasCommand(command)) continue;
            return i;
        }
        return -1;
    }

    private static class ScriptStore {
        ConsoleEngine engine;
        Map<String, Boolean> scripts = new HashMap<String, Boolean>();

        public ScriptStore() {
        }

        public ScriptStore(ConsoleEngine engine) {
            this.engine = engine;
        }

        public void refresh() {
            if (this.engine != null) {
                this.scripts = this.engine.scripts();
            }
        }

        public boolean hasScript(String name) {
            return this.scripts.containsKey(name);
        }

        public boolean isConsoleScript(String name) {
            return this.scripts.getOrDefault(name, false);
        }

        public Set<String> getScripts() {
            return this.scripts.keySet();
        }
    }

    protected static class CommandData {
        private String rawLine;
        private String command;
        private String[] args;
        private File file;
        private boolean append;
        private String variable;
        private String pipe;

        public CommandData(Parser parser, boolean statement, String rawLine, String variable, File file, boolean append, String pipe) {
            this.rawLine = rawLine;
            this.variable = variable;
            this.file = file;
            this.append = append;
            this.pipe = pipe;
            this.args = new String[0];
            if (!statement) {
                ParsedLine plf = parser.parse(rawLine, 0, Parser.ParseContext.ACCEPT_LINE);
                if (plf.words().size() > 1) {
                    this.args = plf.words().subList(1, plf.words().size()).toArray(new String[0]);
                }
                this.command = ConsoleEngine.plainCommand(parser.getCommand((String)plf.words().get(0)));
            } else {
                this.args = new String[0];
                this.command = "";
            }
        }

        public void setPipe(String pipe) {
            this.pipe = pipe;
        }

        public File file() {
            return this.file;
        }

        public boolean append() {
            return this.append;
        }

        public String variable() {
            return this.variable;
        }

        public String command() {
            return this.command;
        }

        public String[] args() {
            return this.args;
        }

        public String rawLine() {
            return this.rawLine;
        }

        public String pipe() {
            return this.pipe;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append("rawLine:").append(this.rawLine);
            sb.append(", ");
            sb.append("command:").append(this.command);
            sb.append(", ");
            sb.append("args:").append(Arrays.asList(this.args));
            sb.append(", ");
            sb.append("variable:").append(this.variable);
            sb.append(", ");
            sb.append("file:").append(this.file);
            sb.append(", ");
            sb.append("append:").append(this.append);
            sb.append(", ");
            sb.append("pipe:").append(this.pipe);
            sb.append("]");
            return sb.toString();
        }
    }

    private static class ArgsParser {
        private int round = 0;
        private int curly = 0;
        private int square = 0;
        private boolean quoted;
        private boolean doubleQuoted;
        private String line;
        private String command;
        private String variable;
        private List<String> args;

        private void reset() {
            this.round = 0;
            this.curly = 0;
            this.square = 0;
            this.quoted = false;
            this.doubleQuoted = false;
        }

        private void next(String arg) {
            int prevChar = 32;
            for (int i = 0; i < arg.length(); ++i) {
                char c = arg.charAt(i);
                if (prevChar != 92) {
                    if (!this.quoted && !this.doubleQuoted) {
                        if (c == '(') {
                            ++this.round;
                        } else if (c == ')') {
                            --this.round;
                        } else if (c == '{') {
                            ++this.curly;
                        } else if (c == '}') {
                            --this.curly;
                        } else if (c == '[') {
                            ++this.square;
                        } else if (c == ']') {
                            --this.square;
                        } else if (c == '\"') {
                            this.doubleQuoted = true;
                        } else if (c == '\'') {
                            this.quoted = true;
                        }
                    } else if (this.quoted && c == '\'') {
                        this.quoted = false;
                    } else if (this.doubleQuoted && c == '\"') {
                        this.doubleQuoted = false;
                    }
                }
                prevChar = c;
            }
        }

        private boolean isEnclosed() {
            return this.round == 0 && this.curly == 0 && this.square == 0 && !this.quoted && !this.doubleQuoted;
        }

        private void enclosedArgs(List<String> words) {
            this.args = new ArrayList<String>();
            this.reset();
            boolean first = true;
            StringBuilder sb = new StringBuilder();
            for (String a : words) {
                this.next(a);
                if (!first) {
                    sb.append(" ");
                }
                if (this.isEnclosed()) {
                    sb.append(a);
                    this.args.add(sb.toString());
                    sb = new StringBuilder();
                    first = true;
                    continue;
                }
                sb.append(a);
                first = false;
            }
            if (!first) {
                this.args.add(sb.toString());
            }
        }

        public void parse(Parser parser, String line) {
            this.line = line;
            ParsedLine pl = parser.parse(line, 0, Parser.ParseContext.SPLIT_LINE);
            this.enclosedArgs(pl.words());
            this.command = ConsoleEngine.plainCommand(parser.getCommand(this.args.get(0)));
            if (!parser.validCommandName(this.command)) {
                this.command = "";
            }
            this.variable = parser.getVariable(this.args.get(0));
        }

        public String line() {
            return this.line;
        }

        public String command() {
            return this.command;
        }

        public String variable() {
            return this.variable;
        }

        public List<String> args() {
            return this.args;
        }
    }

    private static class CommandOutputStream {
        private PrintStream origOut = System.out;
        private PrintStream origErr = System.err;
        private Terminal origTerminal;
        private ByteArrayOutputStream byteOutputStream;
        private FileOutputStream fileOutputStream;
        private PrintStream out;
        private InputStream in;
        private Terminal terminal;
        private String output;
        private CommandRegistry.CommandSession commandSession;
        private boolean redirecting = false;

        public CommandOutputStream(Terminal terminal) {
            this.origTerminal = terminal;
            this.terminal = terminal;
            PrintStream ps = new PrintStream(terminal.output());
            this.commandSession = new CommandRegistry.CommandSession(terminal, terminal.input(), ps, ps);
        }

        public void redirect() throws IOException {
            this.byteOutputStream = new ByteArrayOutputStream();
        }

        public void redirect(File file, boolean append) throws IOException {
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    new File(file.getParent()).mkdirs();
                    file.createNewFile();
                }
            }
            this.fileOutputStream = new FileOutputStream(file, append);
        }

        public void open() throws IOException {
            if (this.redirecting || this.byteOutputStream == null && this.fileOutputStream == null) {
                return;
            }
            OutputStream outputStream = this.byteOutputStream != null ? this.byteOutputStream : this.fileOutputStream;
            this.out = new PrintStream(outputStream);
            System.setOut(this.out);
            System.setErr(this.out);
            String input = KeyMap.ctrl((char)'X') + "q";
            this.in = new ByteArrayInputStream(input.getBytes());
            Attributes attrs = new Attributes();
            if (OSUtils.IS_WINDOWS) {
                attrs.setInputFlag(Attributes.InputFlag.IGNCR, true);
            }
            this.terminal = TerminalBuilder.builder().streams(this.in, outputStream).attributes(attrs).type("dumb").build();
            this.commandSession = new CommandRegistry.CommandSession(this.terminal, this.terminal.input(), this.out, this.out);
            this.redirecting = true;
        }

        public void flush() {
            if (this.out == null) {
                return;
            }
            try {
                this.out.flush();
                if (this.byteOutputStream != null) {
                    this.byteOutputStream.flush();
                    this.output = this.byteOutputStream.toString();
                } else if (this.fileOutputStream != null) {
                    this.fileOutputStream.flush();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void close() {
            if (this.out == null) {
                return;
            }
            try {
                this.in.close();
                this.flush();
                if (this.byteOutputStream != null) {
                    this.byteOutputStream.close();
                    this.byteOutputStream = null;
                } else if (this.fileOutputStream != null) {
                    this.fileOutputStream.close();
                    this.fileOutputStream = null;
                }
                this.out.close();
                this.out = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public CommandRegistry.CommandSession getCommandSession() {
            return this.commandSession;
        }

        public String getOutput() {
            return this.output;
        }

        public boolean isRedirecting() {
            return this.redirecting;
        }

        public boolean isByteStream() {
            return this.redirecting && this.byteOutputStream != null;
        }

        public void reset() {
            if (this.redirecting) {
                this.out = null;
                this.byteOutputStream = null;
                this.fileOutputStream = null;
                this.output = null;
                System.setOut(this.origOut);
                System.setErr(this.origErr);
                this.terminal = null;
                this.terminal = this.origTerminal;
                PrintStream ps = new PrintStream(this.terminal.output());
                this.commandSession = new CommandRegistry.CommandSession(this.terminal, this.terminal.input(), ps, ps);
                this.redirecting = false;
            }
        }

        public void closeAndReset() {
            this.close();
            this.reset();
        }
    }

    public static enum Pipe {
        FLIP,
        NAMED,
        AND,
        OR;

    }

    public static enum Command {
        EXIT,
        HELP;

    }
}

