/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jline.builtins.Completers;
import org.jline.builtins.ConfigurationPath;
import org.jline.builtins.Options;
import org.jline.builtins.SyntaxHighlighter;
import org.jline.console.CommandInput;
import org.jline.console.CommandMethods;
import org.jline.console.CommandRegistry;
import org.jline.console.ConsoleEngine;
import org.jline.console.Printer;
import org.jline.console.ScriptEngine;
import org.jline.console.impl.Builtins;
import org.jline.console.impl.ConsoleEngineImpl;
import org.jline.console.impl.DefaultPrinter;
import org.jline.console.impl.JlineCommandRegistry;
import org.jline.console.impl.SystemHighlighter;
import org.jline.console.impl.SystemRegistryImpl;
import org.jline.keymap.KeyMap;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.Highlighter;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.Reference;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.reader.impl.LineReaderImpl;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.script.GroovyCommand;
import org.jline.script.GroovyEngine;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.InfoCmp;
import org.jline.utils.OSUtils;
import org.jline.widget.TailTipWidgets;

public class Repl {
    public static void main(String[] args) {
        try {
            Supplier<Path> workDir = () -> Paths.get(System.getProperty("user.dir"), new String[0]);
            DefaultParser parser = new DefaultParser();
            parser.setEofOnUnclosedBracket(new DefaultParser.Bracket[]{DefaultParser.Bracket.CURLY, DefaultParser.Bracket.ROUND, DefaultParser.Bracket.SQUARE});
            parser.setEofOnUnclosedQuote(true);
            parser.setRegexCommand("[:]{0,1}[a-zA-Z!]{1,}\\S*");
            parser.blockCommentDelims(new DefaultParser.BlockCommentDelims("/*", "*/")).lineCommentDelims(new String[]{"//"});
            Terminal terminal = TerminalBuilder.builder().build();
            if (terminal.getWidth() == 0 || terminal.getHeight() == 0) {
                terminal.setSize(new Size(120, 40));
            }
            Thread executeThread = Thread.currentThread();
            terminal.handle(Terminal.Signal.INT, signal -> executeThread.interrupt());
            File file = new File(Repl.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            String root = file.getCanonicalPath().replace("classes", "").replaceAll("\\\\", "/");
            File jnanorcFile = Paths.get(root, "jnanorc").toFile();
            if (!jnanorcFile.exists()) {
                try (FileWriter fw = new FileWriter(jnanorcFile);){
                    fw.write("theme " + root + "nanorc/dark.nanorctheme\n");
                    fw.write("include " + root + "nanorc/*.nanorc\n");
                }
            }
            GroovyEngine scriptEngine = new GroovyEngine();
            scriptEngine.put("ROOT", (Object)root);
            ConfigurationPath configPath = new ConfigurationPath(Paths.get(root, new String[0]), Paths.get(root, new String[0]));
            DefaultPrinter printer = new DefaultPrinter((ScriptEngine)scriptEngine, configPath);
            ConsoleEngineImpl consoleEngine = new ConsoleEngineImpl((ScriptEngine)scriptEngine, (Printer)printer, workDir, configPath);
            Builtins builtins = new Builtins(workDir, configPath, fun -> new ConsoleEngine.WidgetCreator((ConsoleEngine)consoleEngine, fun));
            MyCommands myCommands = new MyCommands(workDir);
            ReplSystemRegistry systemRegistry = new ReplSystemRegistry((Parser)parser, terminal, workDir, configPath);
            systemRegistry.register("groovy", (CommandRegistry)new GroovyCommand(scriptEngine, (Printer)printer));
            systemRegistry.setCommandRegistries(new CommandRegistry[]{consoleEngine, builtins, myCommands});
            systemRegistry.addCompleter(scriptEngine.getScriptCompleter());
            systemRegistry.setScriptDescription(arg_0 -> ((GroovyEngine)scriptEngine).scriptDescription(arg_0));
            Path jnanorc = configPath.getConfig("jnanorc");
            scriptEngine.put("NANORC", (Object)jnanorc.toString());
            SyntaxHighlighter commandHighlighter = SyntaxHighlighter.build((Path)jnanorc, (String)"COMMAND");
            SyntaxHighlighter argsHighlighter = SyntaxHighlighter.build((Path)jnanorc, (String)"ARGS");
            SyntaxHighlighter groovyHighlighter = SyntaxHighlighter.build((Path)jnanorc, (String)"Groovy");
            SystemHighlighter highlighter = new SystemHighlighter(commandHighlighter, argsHighlighter, groovyHighlighter);
            if (!OSUtils.IS_WINDOWS) {
                highlighter.setSpecificHighlighter("!", SyntaxHighlighter.build((Path)jnanorc, (String)"SH-REPL"));
            }
            highlighter.addFileHighlight(new String[]{"nano", "less", "slurp"});
            highlighter.addFileHighlight("groovy", "classloader", Arrays.asList("-a", "--add"));
            highlighter.addExternalHighlighterRefresh(() -> ((Printer)printer).refresh());
            highlighter.addExternalHighlighterRefresh(() -> ((GroovyEngine)scriptEngine).refresh());
            LineReader reader = LineReaderBuilder.builder().terminal(terminal).completer(systemRegistry.completer()).parser((Parser)parser).highlighter((Highlighter)highlighter).variable("secondary-prompt-pattern", (Object)"%M%P > ").variable("indentation", (Object)2).variable("list-max", (Object)100).variable("history-file", (Object)Paths.get(root, "history")).option(LineReader.Option.INSERT_BRACKET, true).option(LineReader.Option.EMPTY_WORD_OPTIONS, false).option(LineReader.Option.USE_FORWARD_SLASH, true).option(LineReader.Option.DISABLE_EVENT_EXPANSION, true).build();
            if (OSUtils.IS_WINDOWS) {
                reader.setVariable("blink-matching-paren", (Object)0);
            }
            consoleEngine.setLineReader(reader);
            builtins.setLineReader(reader);
            myCommands.setLineReader(reader);
            new TailTipWidgets(reader, arg_0 -> ((ReplSystemRegistry)systemRegistry).commandDescription(arg_0), 5, TailTipWidgets.TipType.COMPLETER);
            KeyMap keyMap = (KeyMap)reader.getKeyMaps().get("main");
            keyMap.bind((Object)new Reference("tailtip-toggle"), (CharSequence)KeyMap.alt((String)"s"));
            systemRegistry.initialize(Paths.get(root, "init.jline").toFile());
            System.out.println(terminal.getName() + ": " + terminal.getType());
            while (true) {
                try {
                    while (true) {
                        systemRegistry.cleanUp();
                        String line = reader.readLine("groovy-repl> ");
                        line = parser.getCommand(line).startsWith("!") ? line.replaceFirst("!", "! ") : line;
                        Object result = systemRegistry.execute(line);
                        consoleEngine.println(result);
                    }
                }
                catch (UserInterruptException line) {
                    continue;
                }
                catch (EndOfFileException e) {
                    String pl = e.getPartialLine();
                    if (pl == null) break;
                    try {
                        consoleEngine.println(systemRegistry.execute(pl));
                    }
                    catch (Exception e2) {
                        systemRegistry.trace(e2);
                    }
                }
                catch (Error | Exception e) {
                    systemRegistry.trace(e);
                    continue;
                }
                break;
            }
            systemRegistry.close();
            Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
            boolean groovyRunning = false;
            for (Thread t : threadSet) {
                if (!t.getName().startsWith("AWT-Shut")) continue;
                groovyRunning = true;
                break;
            }
            if (groovyRunning) {
                consoleEngine.println((Object)"Please, close Groovy Consoles/Object Browsers!");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected static class MyCommands
    extends JlineCommandRegistry
    implements CommandRegistry {
        private LineReader reader;
        private final Supplier<Path> workDir;

        public MyCommands(Supplier<Path> workDir) {
            this.workDir = workDir;
            HashMap<String, CommandMethods> commandExecute = new HashMap<String, CommandMethods>();
            commandExecute.put("tput", new CommandMethods(this::tput, this::tputCompleter));
            commandExecute.put("testkey", new CommandMethods(this::testkey, arg_0 -> ((MyCommands)this).defaultCompleter(arg_0)));
            commandExecute.put("clear", new CommandMethods(this::clear, arg_0 -> ((MyCommands)this).defaultCompleter(arg_0)));
            commandExecute.put("echo", new CommandMethods(this::echo, arg_0 -> ((MyCommands)this).defaultCompleter(arg_0)));
            commandExecute.put("!", new CommandMethods(this::shell, arg_0 -> ((MyCommands)this).defaultCompleter(arg_0)));
            this.registerCommands(commandExecute);
        }

        public void setLineReader(LineReader reader) {
            this.reader = reader;
        }

        private Terminal terminal() {
            return this.reader.getTerminal();
        }

        private void tput(CommandInput input) {
            String[] usage = new String[]{"tput -  put terminal capability", "Usage: tput [CAPABILITY]", "  -? --help                       Displays command help"};
            try {
                Options opt = this.parseOptions(usage, input.xargs());
                List argv = opt.args();
                if (argv.size() > 0) {
                    InfoCmp.Capability vcap = InfoCmp.Capability.byName((String)((String)argv.get(0)));
                    if (vcap != null) {
                        this.terminal().puts(vcap, opt.argObjects().subList(1, argv.size()).toArray(new Object[0]));
                    } else {
                        this.terminal().writer().println("Unknown capability");
                    }
                } else {
                    this.terminal().writer().println("Usage: tput [CAPABILITY]");
                }
            }
            catch (Exception e) {
                this.saveException(e);
            }
        }

        private void testkey(CommandInput input) {
            String[] usage = new String[]{"testkey -  display the key events", "Usage: testkey", "  -? --help                       Displays command help"};
            try {
                int c;
                this.parseOptions(usage, input.args());
                this.terminal().writer().write("Input the key event(Enter to complete): ");
                this.terminal().writer().flush();
                StringBuilder sb = new StringBuilder();
                while ((c = ((LineReaderImpl)this.reader).readCharacter()) != 10 && c != 13) {
                    sb.append(new String(Character.toChars(c)));
                }
                this.terminal().writer().println(KeyMap.display((String)sb.toString()));
                this.terminal().writer().flush();
            }
            catch (Exception e) {
                this.saveException(e);
            }
        }

        private void clear(CommandInput input) {
            String[] usage = new String[]{"clear -  clear terminal", "Usage: clear", "  -? --help                       Displays command help"};
            try {
                this.parseOptions(usage, input.args());
                this.terminal().puts(InfoCmp.Capability.clear_screen, new Object[0]);
                this.terminal().flush();
            }
            catch (Exception e) {
                this.saveException(e);
            }
        }

        private void echo(CommandInput input) {
            String[] usage = new String[]{"echo - echos a value", "Usage:  echo [-hV] <args>", "-? --help                        Displays command help", "-v --version                     Print version"};
            try {
                Options opt = this.parseOptions(usage, input.args());
                List argv = opt.args();
                if (opt.isSet("version")) {
                    this.terminal().writer().println("echo version: v0.1");
                } else if (opt.args().size() >= 1) {
                    this.terminal().writer().println(String.join((CharSequence)" ", opt.args()));
                }
            }
            catch (Exception e) {
                this.saveException(e);
            }
        }

        private void executeCmnd(List<String> args) throws Exception {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            ArrayList<String> _args = new ArrayList<String>();
            if (OSUtils.IS_WINDOWS) {
                _args.add("cmd.exe");
                _args.add("/c");
            } else {
                _args.add("sh");
                _args.add("-c");
            }
            _args.add(String.join((CharSequence)" ", args));
            builder.command(_args);
            builder.directory(this.workDir.get().toFile());
            Process process = builder.start();
            StreamGobbler streamGobbler = new StreamGobbler(process.getInputStream(), System.out::println);
            Thread th = new Thread(streamGobbler);
            th.start();
            int exitCode = process.waitFor();
            th.join();
            if (exitCode != 0) {
                streamGobbler = new StreamGobbler(process.getErrorStream(), System.out::println);
                th = new Thread(streamGobbler);
                th.start();
                th.join();
                throw new Exception("Error occurred in shell!");
            }
        }

        private void shell(CommandInput input) {
            String[] usage = new String[]{"!<command> -  execute shell command", "Usage: !<command>", "  -? --help                       Displays command help"};
            if (input.args().length == 1 && (input.args()[0].equals("-?") || input.args()[0].equals("--help"))) {
                try {
                    this.parseOptions(usage, input.args());
                }
                catch (Exception e) {
                    this.saveException(e);
                }
            } else {
                ArrayList<String> argv = new ArrayList<String>(Arrays.asList(input.args()));
                if (!argv.isEmpty()) {
                    try {
                        this.executeCmnd(argv);
                    }
                    catch (Exception e) {
                        this.saveException(e);
                    }
                }
            }
        }

        private Set<String> capabilities() {
            return InfoCmp.getCapabilitiesByName().keySet();
        }

        private List<Completer> tputCompleter(String command) {
            ArrayList<Completer> completers = new ArrayList<Completer>();
            completers.add((Completer)new ArgumentCompleter(new Completer[]{NullCompleter.INSTANCE, new Completers.OptionCompleter((Completer)new StringsCompleter(this::capabilities), arg_0 -> ((MyCommands)this).commandOptions(arg_0), 1)}));
            return completers;
        }
    }

    private static class ReplSystemRegistry
    extends SystemRegistryImpl {
        public ReplSystemRegistry(Parser parser, Terminal terminal, Supplier<Path> workDir, ConfigurationPath configPath) {
            super(parser, terminal, workDir, configPath);
        }

        public boolean isCommandOrScript(String command) {
            return command.startsWith("!") || super.isCommandOrScript(command);
        }
    }

    private static class StreamGobbler
    implements Runnable {
        private final InputStream inputStream;
        private final Consumer<String> consumer;

        public StreamGobbler(InputStream inputStream, Consumer<String> consumer) {
            this.inputStream = inputStream;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            new BufferedReader(new InputStreamReader(this.inputStream, StandardCharsets.UTF_8)).lines().forEach(this.consumer);
        }
    }
}

