/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import org.apache.felix.service.command.Converter;
import org.apache.felix.service.command.Function;

public class FunctionConverter
implements Converter {
    public Object convert(Class<?> desiredType, final Object in) throws Exception {
        if (in instanceof Function && desiredType.isInterface() && FunctionConverter.isFunctional(desiredType)) {
            return Proxy.newProxyInstance(desiredType.getClassLoader(), new Class[]{desiredType}, new InvocationHandler(){
                Function command;
                final /* synthetic */ FunctionConverter this$0;
                {
                    this.this$0 = this$0;
                    this.command = (Function)in;
                }

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (FunctionConverter.isObjectMethod(method)) {
                        return method.invoke((Object)this.command, args);
                    }
                    if (method.isDefault()) {
                        Field field = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
                        field.setAccessible(true);
                        MethodHandles.Lookup lookup = (MethodHandles.Lookup)field.get(null);
                        return lookup.unreflectSpecial(method, method.getDeclaringClass()).bindTo(proxy).invokeWithArguments(args);
                    }
                    return this.command.execute(null, args != null ? Arrays.asList(args) : Collections.emptyList());
                }
            });
        }
        return null;
    }

    public CharSequence format(Object target, int level, Converter escape) throws Exception {
        return null;
    }

    public static boolean isFunctional(Class<?> clazz) {
        if (!clazz.isInterface()) {
            return false;
        }
        int nb = 0;
        for (Method method : clazz.getMethods()) {
            if (method.isDefault() || FunctionConverter.isObjectMethod(method) || FunctionConverter.isStatic(method)) continue;
            ++nb;
        }
        return nb == 1;
    }

    public static boolean isStatic(Method method) {
        return (method.getModifiers() & 8) == 8;
    }

    public static boolean isObjectMethod(Method method) {
        switch (method.getName()) {
            case "toString": {
                if (method.getParameterCount() != 0 || method.getReturnType() != String.class) break;
                return true;
            }
            case "equals": {
                if (method.getParameterCount() != 1 || method.getParameterTypes()[0] != Object.class || method.getReturnType() != Boolean.TYPE) break;
                return true;
            }
            case "hashCode": {
                if (method.getParameterCount() != 0 || method.getReturnType() != Integer.TYPE) break;
                return true;
            }
        }
        return false;
    }
}

