/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class ArchitectureExample {
    public static void main(String[] args) throws Exception {
        Terminal terminal = TerminalBuilder.builder().system(true).build();
        LineReader reader = LineReaderBuilder.builder().terminal(terminal).build();
        String line = reader.readLine("prompt> ");
        System.out.println("You entered: " + line);
        StringsCompleter completer = new StringsCompleter(new String[]{"command1", "command2", "help", "quit"});
        LineReader readerWithCompletion = LineReaderBuilder.builder().terminal(terminal).completer((Completer)completer).build();
        Path historyFile = Paths.get(System.getProperty("user.home"), ".myapp_history");
        LineReader readerWithHistory = LineReaderBuilder.builder().terminal(terminal).variable("history-file", (Object)historyFile).build();
        String historyLine = readerWithHistory.readLine("history> ");
        System.out.println("You entered with history: " + historyLine);
        String completionLine = readerWithCompletion.readLine("completion> ");
        System.out.println("You entered with completion: " + completionLine);
        terminal.close();
    }
}

