/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.NonBlockingReader;

public class AsyncInputExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        Terminal terminal = TerminalBuilder.builder().build();
        NonBlockingReader reader = terminal.reader();
        AtomicBoolean running = new AtomicBoolean(true);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(() -> {
            block4: {
                try {
                    while (running.get()) {
                        int c = reader.read(100L);
                        if (c == -1) continue;
                        terminal.writer().println("\nReceived input: " + (char)c);
                        if (c == 113 || c == 81) {
                            running.set(false);
                        }
                        terminal.writer().flush();
                    }
                }
                catch (IOException e) {
                    if (!running.get()) break block4;
                    terminal.writer().println("Error reading input: " + e.getMessage());
                    terminal.writer().flush();
                }
            }
        });
        try {
            terminal.writer().println("Press keys (q to quit):");
            terminal.writer().flush();
            for (int count = 0; running.get() && count < 30; ++count) {
                terminal.writer().print(".");
                terminal.writer().flush();
                TimeUnit.MILLISECONDS.sleep(500L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            running.set(false);
            executor.shutdownNow();
            try {
                executor.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            terminal.writer().println("\nExiting...");
            terminal.close();
        }
    }
}

