/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.widget.AutopairWidgets;

public class AutopairWidgetsExample {
    public static void main(String[] args) throws IOException {
        Terminal terminal = TerminalBuilder.builder().system(true).build();
        LineReader reader = LineReaderBuilder.builder().terminal(terminal).build();
        AutopairWidgets autopairWidgets = new AutopairWidgets(reader, true);
        autopairWidgets.enable();
        terminal.writer().println("Autopair Widgets Example");
        terminal.writer().println("-----------------------");
        terminal.writer().println("Autopair widgets will automatically:");
        terminal.writer().println("1. Insert matching pairs (quotes, brackets)");
        terminal.writer().println("2. Skip over matched pairs");
        terminal.writer().println("3. Auto-delete pairs on backspace");
        terminal.writer().println("4. Expand/contract spaces between brackets");
        terminal.writer().println();
        terminal.writer().println("Try typing quotes, brackets, etc.");
        terminal.writer().println("Type 'exit' to quit");
        terminal.writer().println();
        while (true) {
            try {
                String line;
                while (!(line = reader.readLine("autopair> ")).equalsIgnoreCase("exit")) {
                    terminal.writer().println("You entered: " + line);
                    terminal.writer().flush();
                }
            }
            catch (Exception e) {
                terminal.writer().println("Error: " + e.getMessage());
                terminal.writer().flush();
                continue;
            }
            break;
        }
        terminal.close();
    }
}

