/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.widget.AutosuggestionWidgets;

public class AutosuggestionWidgetsExample {
    public static void main(String[] args) throws IOException {
        Terminal terminal = TerminalBuilder.builder().system(true).build();
        LineReader reader = LineReaderBuilder.builder().terminal(terminal).completer((Completer)new StringsCompleter(new String[]{"help", "hello", "history", "exit", "quit", "clear"})).build();
        AutosuggestionWidgets autosuggestionWidgets = new AutosuggestionWidgets(reader);
        autosuggestionWidgets.enable();
        terminal.writer().println("Autosuggestion Widgets Example");
        terminal.writer().println("-----------------------------");
        terminal.writer().println("As you type, you'll see suggestions based on history.");
        terminal.writer().println("- Press RIGHT ARROW or END to accept the full suggestion");
        terminal.writer().println("- Press Ctrl+F to accept the next word of the suggestion");
        terminal.writer().println("- Type 'exit' to quit");
        terminal.writer().println();
        reader.getHistory().add("help show available commands");
        reader.getHistory().add("hello world");
        reader.getHistory().add("history show command history");
        reader.getHistory().add("clear screen");
        while (true) {
            try {
                String line;
                while (!(line = reader.readLine("autosuggestion> ")).equalsIgnoreCase("exit") && !line.equalsIgnoreCase("quit")) {
                    terminal.writer().println("You entered: " + line);
                    terminal.writer().flush();
                }
            }
            catch (Exception e) {
                terminal.writer().println("Error: " + e.getMessage());
                terminal.writer().flush();
                continue;
            }
            break;
        }
        terminal.close();
    }
}

