/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import org.jline.keymap.KeyMap;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Reference;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class BuiltinWidgetsExample {
    public static void main(String[] args) throws IOException {
        String line;
        Terminal terminal = TerminalBuilder.builder().build();
        LineReader reader = LineReaderBuilder.builder().terminal(terminal).build();
        KeyMap keyMap = (KeyMap)reader.getKeyMaps().get("main");
        keyMap.bind((Object)new Reference("clear-screen"), (CharSequence)KeyMap.ctrl((char)'L'));
        keyMap.bind((Object)new Reference("backward-kill-word"), (CharSequence)KeyMap.alt((char)'h'));
        keyMap.bind((Object)new Reference("kill-word"), (CharSequence)KeyMap.alt((char)'d'));
        keyMap.bind((Object)new Reference("beginning-of-line"), (CharSequence)KeyMap.ctrl((char)'A'));
        keyMap.bind((Object)new Reference("end-of-line"), (CharSequence)KeyMap.ctrl((char)'E'));
        keyMap.bind((Object)new Reference("up-history"), (CharSequence)KeyMap.ctrl((char)'P'));
        keyMap.bind((Object)new Reference("down-history"), (CharSequence)KeyMap.ctrl((char)'N'));
        keyMap.bind((Object)new Reference("backward-word"), (CharSequence)KeyMap.alt((char)'b'));
        keyMap.bind((Object)new Reference("forward-word"), (CharSequence)KeyMap.alt((char)'f'));
        keyMap.bind((Object)new Reference("capitalize-word"), (CharSequence)KeyMap.alt((char)'c'));
        keyMap.bind((Object)new Reference("transpose-chars"), (CharSequence)KeyMap.ctrl((char)'T'));
        terminal.writer().println("Built-in widgets bound to keys:");
        terminal.writer().println("  Ctrl+L: Clear screen");
        terminal.writer().println("  Alt+H: Delete word backward");
        terminal.writer().println("  Alt+D: Delete word forward");
        terminal.writer().println("  Ctrl+A: Move to beginning of line");
        terminal.writer().println("  Ctrl+E: Move to end of line");
        terminal.writer().println("  Ctrl+P: Previous history entry");
        terminal.writer().println("  Ctrl+N: Next history entry");
        terminal.writer().println("  Alt+B: Move backward one word");
        terminal.writer().println("  Alt+F: Move forward one word");
        terminal.writer().println("  Alt+C: Capitalize word");
        terminal.writer().println("  Ctrl+T: Transpose characters");
        terminal.writer().println("\nType some text and try the key bindings:");
        terminal.writer().flush();
        while (!(line = reader.readLine("prompt> ")).equalsIgnoreCase("exit")) {
            terminal.writer().println("You entered: " + line);
        }
        terminal.close();
    }
}

