/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import java.util.Arrays;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class CommonsCliJLineExample {
    public static void main(String[] args) {
        try {
            String line;
            Terminal terminal = TerminalBuilder.builder().system(true).build();
            LineReader reader = LineReaderBuilder.builder().terminal(terminal).build();
            terminal.writer().println("Commons CLI with JLine Example");
            terminal.writer().println("Available commands:");
            terminal.writer().println("  --help, -h           Show help");
            terminal.writer().println("  --greet, -g <name>   Greet someone");
            terminal.writer().println("  --count, -c <number> Count to a number");
            terminal.writer().println("  exit, quit           Exit the application");
            terminal.writer().println();
            while (!(line = reader.readLine("cli> ")).equalsIgnoreCase("exit") && !line.equalsIgnoreCase("quit")) {
                Object[] arguments = line.split("\\s+");
                if (arguments.length > 0) {
                    String cmd = arguments[0];
                    if (cmd.equals("--help") || cmd.equals("-h")) {
                        terminal.writer().println("Help information:");
                        terminal.writer().println("  --help, -h           Show this help message");
                        terminal.writer().println("  --greet, -g <name>   Greet someone");
                        terminal.writer().println("  --count, -c <number> Count to a number");
                        terminal.writer().println("  exit, quit           Exit the application");
                    } else if (cmd.equals("--greet") || cmd.equals("-g")) {
                        String name = arguments.length > 1 ? arguments[1] : "World";
                        terminal.writer().println("Hello, " + name + "!");
                    } else if (cmd.equals("--count") || cmd.equals("-c")) {
                        try {
                            int count = arguments.length > 1 ? Integer.parseInt(arguments[1]) : 10;
                            for (int i = 1; i <= count; ++i) {
                                terminal.writer().println(i);
                            }
                        }
                        catch (NumberFormatException e) {
                            terminal.writer().println("Error: Invalid number format");
                        }
                    } else {
                        terminal.writer().println("Arguments: " + Arrays.toString(arguments));
                        terminal.writer().println("Unknown command. Use --help for usage information.");
                    }
                }
                terminal.flush();
            }
            terminal.writer().println("Goodbye!");
            terminal.close();
        }
        catch (IOException e) {
            System.err.println("Error creating terminal: " + e.getMessage());
        }
    }
}

