/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ConsoleScriptExample {
    public static void consoleScriptExample() throws IOException {
        String consoleScript = "#!/usr/bin/env jline\n\n# This is a simple JLine console script\n# It demonstrates how to use parameters and execute commands\n\n# Access script parameters using $1, $2, etc.\nname=$1\nif [ -z \"$name\" ]; then\n    name=\"World\"\nfi\n\n# Execute commands just like in interactive mode\n:echo \"Hello, $name!\"\n\n# You can use variables\ncount=5\n:echo \"Counting to $count:\"\n\n# Loop example\ni=1\nwhile [ $i -le $count ]; do\n    :echo \"  $i\"\n    i=$((i+1))\ndone\n\n# Return a value from the script\nexit \"Script completed successfully!\"\n";
        Path scriptPath = Paths.get("hello.jline", new String[0]);
        Files.write(scriptPath, consoleScript.getBytes(), new OpenOption[0]);
        System.out.println("Created example console script: " + scriptPath.toAbsolutePath());
        System.out.println("You can run this script in a JLine REPL console with:");
        System.out.println("  ./hello.jline YourName");
    }

    public static void main(String[] args) throws IOException {
        ConsoleScriptExample.consoleScriptExample();
    }
}

