/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import java.util.Map;
import org.jline.consoleui.elements.ConfirmChoice;
import org.jline.consoleui.prompt.ConsolePrompt;
import org.jline.consoleui.prompt.PromptResultItemIF;
import org.jline.consoleui.prompt.builder.PromptBuilder;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class ConsoleUIExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        Terminal terminal = TerminalBuilder.builder().build();
        ConsolePrompt prompt = new ConsolePrompt(terminal);
        PromptBuilder builder = prompt.getPromptBuilder();
        builder.createConfirmPromp().name("continue").message("Do you want to continue?").defaultValue(ConfirmChoice.ConfirmationValue.YES).addPrompt();
        try {
            Map result = prompt.prompt(builder.build());
            System.out.println("You chose: " + result.get("continue"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            terminal.close();
        }
    }

    public void demonstrateInputPrompt(Terminal terminal) {
        ConsolePrompt prompt = new ConsolePrompt(terminal);
        PromptBuilder builder = prompt.getPromptBuilder();
        builder.createInputPrompt().name("username").message("Enter your username").defaultValue("admin").addPrompt();
        builder.createInputPrompt().name("password").message("Enter your password").mask('*').addPrompt();
        try {
            Map result = prompt.prompt(builder.build());
            String username = ((PromptResultItemIF)result.get("username")).getResult();
            String password = ((PromptResultItemIF)result.get("password")).getResult();
            System.out.println("Logged in as: " + username);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void demonstrateListPrompt(Terminal terminal) {
        ConsolePrompt prompt = new ConsolePrompt(terminal);
        PromptBuilder builder = prompt.getPromptBuilder();
        builder.createListPrompt().name("color").message("Choose your favorite color").newItem().text("Red").add().newItem("green").text("Green").add().newItem("blue").text("Blue").add().newItem("yellow").text("Yellow").add().pageSize(3).addPrompt();
        try {
            Map result = prompt.prompt(builder.build());
            System.out.println("Selected color: " + ((PromptResultItemIF)result.get("color")).getResult());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void demonstrateCheckboxPrompt(Terminal terminal) {
        ConsolePrompt prompt = new ConsolePrompt(terminal);
        PromptBuilder builder = prompt.getPromptBuilder();
        builder.createCheckboxPrompt().name("toppings").message("Select pizza toppings").newSeparator("Vegetables").add().newItem("tomato").text("Tomato").add().newItem("onion").text("Onion").add().newItem("pepper").text("Bell Pepper").add().newSeparator("Meats").add().newItem("pepperoni").text("Pepperoni").check().add().newItem("sausage").text("Sausage").add().newItem("bacon").text("Bacon").add().newSeparator("Others").add().newItem("extra_cheese").text("Extra Cheese").check().add().newItem("pineapple").text("Pineapple").disabledText("Temporarily unavailable").add().addPrompt();
        try {
            Map result = prompt.prompt(builder.build());
            System.out.println("Selected toppings: " + ((PromptResultItemIF)result.get("toppings")).getResult());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void demonstrateChoicePrompt(Terminal terminal) {
        ConsolePrompt prompt = new ConsolePrompt(terminal);
        PromptBuilder builder = prompt.getPromptBuilder();
        builder.createChoicePrompt().name("payment").message("How would you like to pay?").newItem().name("cash").message("Cash").key('c').asDefault().add().newItem("credit").message("Credit Card").key('r').add().newItem("debit").message("Debit Card").key('d').add().newSeparator("Online Options").add().newItem("paypal").message("PayPal").key('p').add().newItem("crypto").message("Cryptocurrency").key('y').add().addPrompt();
        try {
            Map result = prompt.prompt(builder.build());
            System.out.println("Selected payment method: " + ((PromptResultItemIF)result.get("payment")).getResult());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

