/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jline.builtins.Completers;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.reader.impl.completer.StringsCompleter;

public class ContextAwareCompleter
implements Completer {
    private final Map<String, Completer> contextCompleters = new HashMap<String, Completer>();

    public ContextAwareCompleter() {
        this.contextCompleters.put("default", (Completer)new StringsCompleter(new String[]{"help", "context", "exit"}));
        this.contextCompleters.put("file", (Completer)new Completers.FilesCompleter(Paths.get("", new String[0])));
        this.contextCompleters.put("user", (Completer)new StringsCompleter(new String[]{"admin", "guest", "user1", "user2"}));
    }

    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        String context = (String)reader.getVariable("CONTEXT");
        if (context == null) {
            context = "default";
        }
        Completer contextCompleter = this.contextCompleters.getOrDefault(context, this.contextCompleters.get("default"));
        contextCompleter.complete(reader, line, candidates);
    }
}

