/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import org.jline.keymap.KeyMap;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Reference;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.widget.Widgets;

public class CustomWidgetsClassExample {
    public static void main(String[] args) {
        try {
            Terminal terminal = TerminalBuilder.builder().system(true).build();
            LineReader reader = LineReaderBuilder.builder().terminal(terminal).build();
            MyWidgets widgets = MyWidgets.create(reader);
            terminal.writer().println("Custom Widgets Class Example");
            terminal.writer().println("  Ctrl+Alt+X: Execute the first word as a command");
            terminal.writer().println("  Ctrl+Alt+C: Clear the line");
            terminal.writer().println();
            terminal.writer().println("Try typing 'clear-line' and then press Ctrl+Alt+X");
            terminal.writer().flush();
            String prompt = "widgets> ";
            while (true) {
                try {
                    String line;
                    while (!"exit".equalsIgnoreCase(line = reader.readLine(prompt))) {
                        terminal.writer().println("You entered: " + line);
                        terminal.writer().flush();
                    }
                }
                catch (UserInterruptException e) {
                    terminal.writer().println("KeyboardInterrupt (Ctrl+C)");
                    terminal.writer().flush();
                    continue;
                }
                catch (EndOfFileException e) {
                    terminal.writer().println("End of file (Ctrl+D)");
                    terminal.writer().flush();
                }
                break;
            }
            terminal.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class MyWidgets
    extends Widgets {
        public static MyWidgets create(LineReader reader) {
            MyWidgets widgets = new MyWidgets(reader);
            widgets.addWidget("execute-command", widgets::executeCommand);
            widgets.addWidget("clear-line", widgets::clearLine);
            widgets.getKeyMap().bind((Object)new Reference("execute-command"), (CharSequence)KeyMap.alt((String)KeyMap.ctrl((char)'X')));
            widgets.getKeyMap().bind((Object)new Reference("clear-line"), (CharSequence)KeyMap.alt((String)KeyMap.ctrl((char)'C')));
            return widgets;
        }

        private MyWidgets(LineReader reader) {
            super(reader);
        }

        public boolean executeCommand() {
            try {
                String buffer = this.buffer().toString();
                String[] words = buffer.split("\\s+");
                if (words.length > 0 && !words[0].isEmpty()) {
                    String command = words[0];
                    System.out.println("\nExecuting command: " + command);
                    try {
                        this.reader.callWidget(command);
                        return true;
                    }
                    catch (Exception e) {
                        System.out.println("No widget named: " + command);
                        return false;
                    }
                }
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public boolean clearLine() {
            this.buffer().clear();
            return true;
        }
    }
}

