/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class EditingModesExample {
    public static void main(String[] args) throws IOException {
        Terminal terminal = TerminalBuilder.builder().build();
        LineReader emacsReader = LineReaderBuilder.builder().terminal(terminal).variable("editing-mode", (Object)"emacs").build();
        LineReader viReader = LineReaderBuilder.builder().terminal(terminal).variable("editing-mode", (Object)"vi").build();
        terminal.writer().println("Emacs editing mode:");
        terminal.writer().println("  Ctrl+A: Beginning of line");
        terminal.writer().println("  Ctrl+E: End of line");
        terminal.writer().println("  Ctrl+F: Forward character");
        terminal.writer().println("  Ctrl+B: Backward character");
        terminal.writer().println("  Alt+F: Forward word");
        terminal.writer().println("  Alt+B: Backward word");
        terminal.writer().println("  Ctrl+K: Kill to end of line");
        terminal.writer().println("  Ctrl+Y: Yank (paste)");
        terminal.writer().println("\nType some text in Emacs mode:");
        terminal.writer().flush();
        String line = emacsReader.readLine("emacs> ");
        terminal.writer().println("You entered: " + line);
        terminal.writer().println("\nVi editing mode:");
        terminal.writer().println("  ESC: Enter command mode");
        terminal.writer().println("  i: Enter insert mode");
        terminal.writer().println("  h, j, k, l: Move cursor");
        terminal.writer().println("  w: Forward word");
        terminal.writer().println("  b: Backward word");
        terminal.writer().println("  d: Delete");
        terminal.writer().println("  y: Yank (copy)");
        terminal.writer().println("  p: Put (paste)");
        terminal.writer().println("\nType some text in Vi mode:");
        terminal.writer().flush();
        line = viReader.readLine("vi> ");
        terminal.writer().println("You entered: " + line);
        terminal.close();
    }
}

