/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class FileOperationsExample {
    public static void main(String[] args) throws Exception {
        String line;
        Terminal terminal = TerminalBuilder.builder().system(true).build();
        Path workDir = Files.createTempDirectory("jline-demo", new FileAttribute[0]);
        workDir.toFile().deleteOnExit();
        Path file1 = workDir.resolve("sample1.txt");
        Path file2 = workDir.resolve("sample2.txt");
        Files.write(file1, "This is sample file 1\nWith multiple lines\nFor demonstration".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.write(file2, "This is sample file 2\nWith different content\nFor comparison".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        LineReader reader = LineReaderBuilder.builder().terminal(terminal).parser((Parser)new DefaultParser()).build();
        terminal.writer().println("File Operations Example");
        terminal.writer().println("Working directory: " + workDir);
        terminal.writer().println("Available commands: cat, ls, grep");
        terminal.writer().println("Type 'exit' to quit");
        terminal.writer().println();
        while (!(line = reader.readLine("file-ops> ")).equals("exit") && !line.equals("quit")) {
            try {
                String[] parts = line.split("\\s+");
                String command = parts[0];
                if (command.equals("ls")) {
                    File[] files = workDir.toFile().listFiles();
                    if (files != null) {
                        for (File file : files) {
                            terminal.writer().println(file.getName() + "\t" + file.length() + " bytes");
                        }
                    }
                } else if (command.equals("cat") && parts.length > 1) {
                    Path filePath = workDir.resolve(parts[1]);
                    if (Files.exists(filePath, new LinkOption[0])) {
                        Files.lines(filePath).forEach(terminal.writer()::println);
                    } else {
                        terminal.writer().println("File not found: " + parts[1]);
                    }
                } else if (command.equals("grep") && parts.length > 2) {
                    String pattern = parts[1];
                    Path filePath = workDir.resolve(parts[2]);
                    if (Files.exists(filePath, new LinkOption[0])) {
                        Files.lines(filePath).filter(line2 -> line2.contains(pattern)).forEach(terminal.writer()::println);
                    } else {
                        terminal.writer().println("File not found: " + parts[2]);
                    }
                } else {
                    terminal.writer().println("Unknown command or invalid syntax: " + line);
                    terminal.writer().println("Available commands: cat <file>, ls, grep <pattern> <file>");
                }
            }
            catch (Exception e) {
                terminal.writer().println("Error: " + e.getMessage());
            }
            terminal.flush();
        }
        terminal.writer().println("Goodbye!");
        terminal.close();
    }
}

