/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class GroovyScriptExample {
    public static void groovyScriptExample() throws IOException {
        String groovyScript = "#!/usr/bin/env groovy\n\n// This is a simple JLine Groovy script\n// It demonstrates how to use parameters and execute commands\n\n// Access script parameters using the _args list\ndef name = _args.size() > 0 ? _args[0] : \"World\"\n\n// Print directly using Groovy\nprintln \"Hello, ${name}!\"\n\n// Execute console commands using SystemRegistry\nimport org.jline.console.SystemRegistry\n\n// Create a map to print\ndef user = [name: name, greeting: \"Hello\", count: 5]\n\n// Print the map using the prnt command\nSystemRegistry.get().invoke(\"prnt\", \"-s\", \"JSON\", user)\n\n// Loop example\nprintln \"Counting to ${user.count}:\"\nfor (i in 1..user.count) {\n    println \"  ${i}\"\n}\n\n// Return a value from the script\nreturn \"Script completed successfully!\"\n";
        Path scriptPath = Paths.get("hello.groovy", new String[0]);
        Files.write(scriptPath, groovyScript.getBytes(), new OpenOption[0]);
        System.out.println("Created example Groovy script: " + scriptPath.toAbsolutePath());
        System.out.println("You can run this script in a JLine REPL console with:");
        System.out.println("  ./hello.groovy YourName");
    }

    public static void main(String[] args) throws IOException {
        GroovyScriptExample.groovyScriptExample();
    }
}

