/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import org.jline.keymap.KeyMap;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Reference;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class KeyBindingExample {
    public static void main(String[] args) {
        try {
            Terminal terminal = TerminalBuilder.builder().system(true).build();
            LineReader reader = LineReaderBuilder.builder().terminal(terminal).build();
            KeyMap keyMap = (KeyMap)reader.getKeyMaps().get("main");
            keyMap.bind((Object)new Reference("transpose-chars"), (CharSequence)KeyMap.ctrl((char)'T'));
            keyMap.bind((Object)new Reference("upcase-word"), (CharSequence)KeyMap.alt((char)'U'));
            keyMap.bind((Object)new Reference("downcase-word"), (CharSequence)KeyMap.alt((char)'L'));
            keyMap.bind((Object)new Reference("capitalize-word"), (CharSequence)KeyMap.alt((char)'C'));
            keyMap.bind((Object)new Reference("kill-line"), (CharSequence)KeyMap.ctrl((char)'K'));
            keyMap.bind((Object)new Reference("yank"), (CharSequence)KeyMap.ctrl((char)'Y'));
            keyMap.bind((Object)new Reference("history-incremental-search-backward"), (CharSequence)KeyMap.ctrl((char)'R'));
            terminal.writer().println("Key Binding Example");
            terminal.writer().println("------------------");
            terminal.writer().println("Try these key bindings:");
            terminal.writer().println("  Ctrl+T: Transpose characters");
            terminal.writer().println("  Alt+U: Uppercase word");
            terminal.writer().println("  Alt+L: Lowercase word");
            terminal.writer().println("  Alt+C: Capitalize word");
            terminal.writer().println("  Ctrl+K: Kill line");
            terminal.writer().println("  Ctrl+Y: Yank");
            terminal.writer().println("  Ctrl+R: Search history");
            terminal.writer().println();
            terminal.writer().println("Type 'exit' to quit");
            terminal.writer().println();
            while (true) {
                try {
                    String line;
                    while (!"exit".equalsIgnoreCase(line = reader.readLine("keybinding> "))) {
                        terminal.writer().println("You entered: " + line);
                        terminal.writer().flush();
                    }
                }
                catch (UserInterruptException e) {
                    terminal.writer().println("Interrupted");
                    continue;
                }
                catch (EndOfFileException e) {
                    terminal.writer().println("EOF");
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

