/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jline.reader.Highlighter;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class KeywordHighlighterExample {
    public static void main(String[] args) throws IOException {
        Highlighter sqlHighlighter = new Highlighter(){
            private final Pattern SQL_KEYWORDS = Pattern.compile("\\b(SELECT|FROM|WHERE|JOIN|ON|GROUP BY|ORDER BY|HAVING|INSERT|UPDATE|DELETE|CREATE|DROP|ALTER)\\b", 2);

            public AttributedString highlight(LineReader reader, String buffer) {
                AttributedStringBuilder builder = new AttributedStringBuilder();
                Matcher matcher = this.SQL_KEYWORDS.matcher(buffer);
                int lastEnd = 0;
                while (matcher.find()) {
                    builder.append((CharSequence)buffer.substring(lastEnd, matcher.start()));
                    builder.styled(AttributedStyle.BOLD.foreground(4), (CharSequence)buffer.substring(matcher.start(), matcher.end()));
                    lastEnd = matcher.end();
                }
                if (lastEnd < buffer.length()) {
                    builder.append((CharSequence)buffer.substring(lastEnd));
                }
                return builder.toAttributedString();
            }
        };
        Terminal terminal = TerminalBuilder.builder().build();
        LineReader reader = LineReaderBuilder.builder().terminal(terminal).highlighter(sqlHighlighter).build();
        terminal.writer().println("SQL Keyword Highlighter Example");
        terminal.writer().println("Try typing SQL queries like: SELECT * FROM users WHERE id = 1");
        terminal.writer().println();
        String line = reader.readLine("sql> ");
        terminal.writer().println("You entered: " + line);
        terminal.close();
    }
}

