/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.NonBlockingReader;

public class MouseEventHandlingExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        Terminal terminal = TerminalBuilder.builder().build();
        try {
            int c;
            terminal.handle(Terminal.Signal.INT, Terminal.SignalHandler.SIG_IGN);
            terminal.trackMouse(Terminal.MouseTracking.Normal);
            System.out.println("Mouse tracking enabled. Click or move the mouse in the terminal...");
            System.out.println("Press 'q' to exit.");
            NonBlockingReader reader = terminal.reader();
            StringBuilder buffer = new StringBuilder();
            boolean esc = false;
            boolean bracket = false;
            boolean mouse = false;
            while ((c = reader.read()) != 113) {
                if (c == 27) {
                    esc = true;
                    buffer.setLength(0);
                    continue;
                }
                if (esc && c == 91) {
                    bracket = true;
                    continue;
                }
                if (esc && bracket && c == 77) {
                    mouse = true;
                    buffer.setLength(0);
                    continue;
                }
                if (mouse && buffer.length() < 3) {
                    buffer.append((char)c);
                    if (buffer.length() != 3) continue;
                    int b = buffer.charAt(0) - 32;
                    int x = buffer.charAt(1) - 32;
                    int y = buffer.charAt(2) - 32;
                    boolean press = (b & 3) != 3;
                    boolean release = (b & 3) == 3;
                    boolean wheel = (b & 0x40) != 0;
                    String button = "unknown";
                    if ((b & 3) == 0) {
                        button = "left";
                    }
                    if ((b & 3) == 1) {
                        button = "middle";
                    }
                    if ((b & 3) == 2) {
                        button = "right";
                    }
                    terminal.writer().println(String.format("Mouse event: %s button %s at position (%d,%d)", press ? "pressed" : (release ? "released" : (wheel ? "wheel" : "moved")), button, x, y));
                    terminal.flush();
                    esc = false;
                    bracket = false;
                    mouse = false;
                    continue;
                }
                esc = false;
                bracket = false;
                mouse = false;
            }
        }
        finally {
            terminal.trackMouse(Terminal.MouseTracking.Off);
            terminal.close();
        }
    }
}

