/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.ParsedLine;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import picocli.CommandLine;
import picocli.shell.jline3.PicocliJLineCompleter;

public class PicocliCompletionExample {
    public static void main(String[] args) {
        try {
            String line;
            Terminal terminal = TerminalBuilder.builder().system(true).build();
            RootCommand rootCommand = new RootCommand(terminal);
            CommandLine commandLine = new CommandLine((Object)rootCommand);
            commandLine.addSubcommand("hello", (Object)new HelloCommand(terminal));
            commandLine.addSubcommand("echo", (Object)new EchoCommand(terminal));
            PicocliJLineCompleter completer = new PicocliJLineCompleter(commandLine.getCommandSpec());
            LineReader reader = LineReaderBuilder.builder().terminal(terminal).completer((Completer)completer).build();
            while (!(line = reader.readLine("cli> ")).equalsIgnoreCase("exit") && !line.equalsIgnoreCase("quit")) {
                try {
                    ParsedLine pl = reader.getParser().parse(line, 0);
                    String[] arguments = pl.words().toArray(new String[0]);
                    commandLine.execute(arguments);
                }
                catch (Exception e) {
                    terminal.writer().println("Error: " + e.getMessage());
                    terminal.flush();
                }
            }
            terminal.writer().println("Goodbye!");
            terminal.close();
        }
        catch (IOException e) {
            System.err.println("Error creating terminal: " + e.getMessage());
        }
    }

    @CommandLine.Command(name="cli", mixinStandardHelpOptions=true, version={"1.0"}, description={"Interactive CLI with JLine and Picocli"})
    static class RootCommand
    implements Callable<Integer> {
        private final Terminal terminal;

        public RootCommand(Terminal terminal) {
            this.terminal = terminal;
        }

        @Override
        public Integer call() {
            this.terminal.writer().println("Use one of the available commands:");
            this.terminal.writer().println("  hello - Say hello");
            this.terminal.writer().println("  echo - Echo a message");
            this.terminal.writer().println("  help - Show help");
            this.terminal.writer().println("  exit - Exit the application");
            this.terminal.flush();
            return 0;
        }
    }

    @CommandLine.Command(name="hello", description={"Say hello"})
    static class HelloCommand
    implements Callable<Integer> {
        private final Terminal terminal;
        @CommandLine.Option(names={"-n", "--name"}, description={"Name to greet"})
        private String name = "World";

        public HelloCommand(Terminal terminal) {
            this.terminal = terminal;
        }

        @Override
        public Integer call() {
            this.terminal.writer().println("Hello, " + this.name + "!");
            this.terminal.flush();
            return 0;
        }
    }

    @CommandLine.Command(name="echo", description={"Echo a message"})
    static class EchoCommand
    implements Callable<Integer> {
        private final Terminal terminal;
        @CommandLine.Option(names={"-u", "--uppercase"}, description={"Convert to uppercase"})
        private boolean uppercase;
        @CommandLine.Parameters(description={"Message to echo"})
        private List<String> message;

        public EchoCommand(Terminal terminal) {
            this.terminal = terminal;
        }

        @Override
        public Integer call() {
            if (this.message == null || this.message.isEmpty()) {
                this.terminal.writer().println("No message provided");
            } else {
                String result = String.join((CharSequence)" ", this.message);
                if (this.uppercase) {
                    result = result.toUpperCase();
                }
                this.terminal.writer().println(result);
            }
            this.terminal.flush();
            return 0;
        }
    }
}

