/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class ProgressBarExample {
    public static void main(String[] args) throws IOException {
        Terminal terminal = TerminalBuilder.builder().build();
        for (int i = 0; i <= 100; i += 5) {
            AttributedString progressBar = ProgressBarExample.createProgressBar(i, 50);
            terminal.writer().print("\r");
            progressBar.print(terminal);
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        terminal.writer().println();
        terminal.close();
    }

    private static AttributedString createProgressBar(int percentage, int width) {
        AttributedStringBuilder builder = new AttributedStringBuilder();
        int completed = width * percentage / 100;
        int remaining = width - completed;
        builder.style(AttributedStyle.DEFAULT.bold()).append((CharSequence)String.format("%3d%% ", percentage));
        builder.append((CharSequence)"[");
        builder.style(AttributedStyle.DEFAULT.foreground(2)).append((CharSequence)ProgressBarExample.repeat("=", completed));
        builder.style(AttributedStyle.DEFAULT.foreground(0)).append((CharSequence)ProgressBarExample.repeat(" ", remaining));
        builder.style(AttributedStyle.DEFAULT).append((CharSequence)"]");
        return builder.toAttributedString();
    }

    private static String repeat(String str, int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }
}

