/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.util.List;
import java.util.regex.Pattern;
import org.jline.builtins.Completers;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.ParsedLine;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class RegexCompleterExample {
    public static void main(String[] args) throws Exception {
        Terminal terminal = TerminalBuilder.builder().system(true).build();
        StringsCompleter commandCompleter = new StringsCompleter(new String[]{"cat", "ls", "grep"});
        StringsCompleter optionCompleter = new StringsCompleter(new String[]{"--color", "--help", "--version"});
        Completers.FileNameCompleter fileCompleter = new Completers.FileNameCompleter();
        Completer patternCompleter = new Completer(){
            private final Pattern commandPattern = Pattern.compile("^(cat|ls|grep)$");
            private final Pattern optionPattern = Pattern.compile("^(cat|ls|grep)\\s+(--[a-z]+)$");
            private final Pattern filePattern = Pattern.compile("^(cat|ls|grep)\\s+(--[a-z]+\\s+)?(.*)$");
            final /* synthetic */ Completer val$commandCompleter;
            final /* synthetic */ Completer val$optionCompleter;
            final /* synthetic */ Completer val$fileCompleter;
            {
                this.val$commandCompleter = completer;
                this.val$optionCompleter = completer2;
                this.val$fileCompleter = completer3;
            }

            public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
                String buffer = line.line();
                if (buffer.trim().isEmpty() || this.commandPattern.matcher(buffer).matches()) {
                    this.val$commandCompleter.complete(reader, line, candidates);
                } else if (this.optionPattern.matcher(buffer).matches()) {
                    this.val$optionCompleter.complete(reader, line, candidates);
                } else if (this.filePattern.matcher(buffer).matches()) {
                    this.val$fileCompleter.complete(reader, line, candidates);
                }
            }
        };
        LineReader reader = LineReaderBuilder.builder().terminal(terminal).completer(patternCompleter).build();
        String line = reader.readLine("Enter a command: ");
        System.out.println("You entered: " + line);
        terminal.close();
    }
}

