/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;
import org.jline.utils.Display;

public class ResponsiveUIExample {
    public static void main(String[] args) throws IOException, InterruptedException {
        Terminal terminal = TerminalBuilder.builder().build();
        Display display = new Display(terminal, true);
        Size size = terminal.getSize();
        List<AttributedString> content = ResponsiveUIExample.createContent(size);
        display.resize(size.getRows(), size.getColumns());
        display.update(content, -1);
        terminal.handle(Terminal.Signal.WINCH, signal -> {
            Size newSize = terminal.getSize();
            List<AttributedString> newContent = ResponsiveUIExample.createContent(newSize);
            display.resize(newSize.getRows(), newSize.getColumns());
            display.update(newContent, -1);
        });
        terminal.writer().println("\nResize your terminal window to see the UI adapt.");
        terminal.writer().println("Press Enter to exit.");
        terminal.writer().flush();
        terminal.reader().read();
        terminal.close();
    }

    private static List<AttributedString> createContent(Size size) {
        ArrayList<AttributedString> content = new ArrayList<AttributedString>();
        content.add(new AttributedString((CharSequence)"Responsive UI Example", AttributedStyle.DEFAULT.foreground(4).bold()));
        content.add(new AttributedString((CharSequence)("Terminal size: " + size.getColumns() + "x" + size.getRows())));
        content.add(new AttributedString((CharSequence)""));
        int availableWidth = size.getColumns() - 4;
        if (availableWidth >= 60) {
            content.add(new AttributedString((CharSequence)"ID  | Name                | Description"));
            content.add(new AttributedString((CharSequence)"----+---------------------+-------------------------"));
            content.add(new AttributedString((CharSequence)"1   | Item One            | First item in the list"));
            content.add(new AttributedString((CharSequence)"2   | Item Two            | Second item in the list"));
            content.add(new AttributedString((CharSequence)"3   | Item Three          | Third item in the list"));
        } else if (availableWidth >= 40) {
            content.add(new AttributedString((CharSequence)"ID  | Name"));
            content.add(new AttributedString((CharSequence)"----+---------------------"));
            content.add(new AttributedString((CharSequence)"1   | Item One"));
            content.add(new AttributedString((CharSequence)"2   | Item Two"));
            content.add(new AttributedString((CharSequence)"3   | Item Three"));
            content.add(new AttributedString((CharSequence)""));
            content.add(new AttributedString((CharSequence)"Descriptions:"));
            content.add(new AttributedString((CharSequence)"1: First item in the list"));
            content.add(new AttributedString((CharSequence)"2: Second item in the list"));
            content.add(new AttributedString((CharSequence)"3: Third item in the list"));
        } else {
            content.add(new AttributedString((CharSequence)"Items:"));
            content.add(new AttributedString((CharSequence)""));
            content.add(new AttributedString((CharSequence)"1: Item One"));
            content.add(new AttributedString((CharSequence)"2: Item Two"));
            content.add(new AttributedString((CharSequence)"3: Item Three"));
        }
        return content;
    }
}

