/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;

public class SpringShellJLineExample {
    public static void main(String[] args) throws IOException {
        String line;
        Terminal terminal = SpringShellJLineExample.createTerminal();
        LineReader lineReader = SpringShellJLineExample.createLineReader(terminal);
        String prompt = SpringShellJLineExample.createPrompt();
        System.out.println("Spring Shell with JLine Example");
        System.out.println("Type 'help' to see available commands");
        System.out.println("Type 'exit' to quit");
        while (!(line = lineReader.readLine(prompt)).equals("exit")) {
            String[] parts;
            if (line.equals("help")) {
                System.out.println("Available commands:");
                System.out.println("  help    - Show this help");
                System.out.println("  echo    - Echo a message");
                System.out.println("  hello   - Say hello");
                System.out.println("  sum     - Sum two numbers");
                System.out.println("  exit    - Exit the application");
                continue;
            }
            if (line.startsWith("echo")) {
                parts = line.split("\\s+", 2);
                if (parts.length > 1) {
                    System.out.println(parts[1]);
                    continue;
                }
                System.out.println("Usage: echo <message>");
                continue;
            }
            if (line.startsWith("hello")) {
                parts = line.split("\\s+", 2);
                String name = parts.length > 1 ? parts[1] : "World";
                System.out.println("Hello, " + name + "!");
                continue;
            }
            if (line.startsWith("sum")) {
                parts = line.split("\\s+");
                if (parts.length == 3) {
                    try {
                        int a = Integer.parseInt(parts[1]);
                        int b = Integer.parseInt(parts[2]);
                        System.out.println(a + " + " + b + " = " + (a + b));
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error: Invalid numbers");
                    }
                    continue;
                }
                System.out.println("Usage: sum <a> <b>");
                continue;
            }
            if (line.isEmpty()) continue;
            System.out.println("Unknown command: " + line);
        }
        System.out.println("Goodbye!");
        terminal.close();
    }

    private static Terminal createTerminal() throws IOException {
        return TerminalBuilder.builder().system(true).build();
    }

    private static LineReader createLineReader(Terminal terminal) {
        return LineReaderBuilder.builder().terminal(terminal).option(LineReader.Option.AUTO_FRESH_LINE, true).option(LineReader.Option.HISTORY_BEEP, false).build();
    }

    private static String createPrompt() {
        return new AttributedString((CharSequence)"custom-shell:> ", AttributedStyle.DEFAULT.foreground(3)).toAnsi();
    }
}

