/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class StatusMessageExample {
    public static AttributedString createStatusMessage(String status) {
        AttributedStringBuilder builder = new AttributedStringBuilder();
        builder.append((CharSequence)"Status: ");
        switch (status.toLowerCase()) {
            case "success": {
                builder.style(AttributedStyle.DEFAULT.foreground(2)).append((CharSequence)"SUCCESS");
                break;
            }
            case "warning": {
                builder.style(AttributedStyle.DEFAULT.foreground(3)).append((CharSequence)"WARNING");
                break;
            }
            case "error": {
                builder.style(AttributedStyle.DEFAULT.foreground(1)).append((CharSequence)"ERROR");
                break;
            }
            default: {
                builder.append((CharSequence)status);
            }
        }
        return builder.toAttributedString();
    }

    public static void main(String[] args) throws IOException {
        Terminal terminal = TerminalBuilder.builder().system(true).build();
        StatusMessageExample.createStatusMessage("success").println(terminal);
        StatusMessageExample.createStatusMessage("warning").println(terminal);
        StatusMessageExample.createStatusMessage("error").println(terminal);
        StatusMessageExample.createStatusMessage("unknown").println(terminal);
        terminal.close();
    }
}

