/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jline.reader.Highlighter;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class SyntaxHighlighterExample {
    public static void main(String[] args) throws IOException {
        Highlighter syntaxHighlighter = new Highlighter(){
            private final Pattern KEYWORDS = Pattern.compile("\\b(if|else|while|for|return|function|var|let|const)\\b");
            private final Pattern STRINGS = Pattern.compile("\"[^\"\\\\]*(\\\\.[^\"\\\\]*)*\"|'[^'\\\\]*(\\\\.[^'\\\\]*)*'");
            private final Pattern NUMBERS = Pattern.compile("\\b\\d+(\\.\\d+)?\\b");
            private final Pattern COMMENTS = Pattern.compile("//.*$|/\\*[\\s\\S]*?\\*/", 8);

            public AttributedString highlight(LineReader reader, String buffer) {
                String workingBuffer = buffer;
                AttributedStringBuilder builder = new AttributedStringBuilder();
                workingBuffer = this.highlightPattern(builder, workingBuffer, this.COMMENTS, AttributedStyle.DEFAULT.foreground(2));
                workingBuffer = this.highlightPattern(builder, workingBuffer, this.STRINGS, AttributedStyle.DEFAULT.foreground(3));
                workingBuffer = this.highlightPattern(builder, workingBuffer, this.NUMBERS, AttributedStyle.DEFAULT.foreground(6));
                if (!(workingBuffer = this.highlightPattern(builder, workingBuffer, this.KEYWORDS, AttributedStyle.BOLD.foreground(5))).isEmpty()) {
                    builder.append((CharSequence)workingBuffer);
                }
                return builder.toAttributedString();
            }

            private String highlightPattern(AttributedStringBuilder builder, String buffer, Pattern pattern, AttributedStyle style) {
                StringBuilder result = new StringBuilder();
                Matcher matcher = pattern.matcher(buffer);
                int lastEnd = 0;
                while (matcher.find()) {
                    result.append(buffer, lastEnd, matcher.start());
                    builder.styled(style, (CharSequence)buffer.substring(matcher.start(), matcher.end()));
                    lastEnd = matcher.end();
                }
                if (lastEnd < buffer.length()) {
                    result.append(buffer.substring(lastEnd));
                }
                return result.toString();
            }
        };
        Terminal terminal = TerminalBuilder.builder().build();
        LineReader reader = LineReaderBuilder.builder().terminal(terminal).highlighter(syntaxHighlighter).build();
        terminal.writer().println("Syntax Highlighter Example");
        terminal.writer().println("Try typing code like: function add(a, b) { return a + b; // Add numbers }");
        terminal.writer().println();
        String line = reader.readLine("code> ");
        terminal.writer().println("You entered: " + line);
        terminal.close();
    }
}

