/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.function.Function;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class SystemRegistryExample {
    public static void main(String[] args) throws Exception {
        String line;
        Terminal terminal = TerminalBuilder.builder().system(true).build();
        Path workDir = Paths.get(System.getProperty("user.dir"), new String[0]);
        LineReader reader = LineReaderBuilder.builder().terminal(terminal).parser((Parser)new DefaultParser()).build();
        HashMap<String, Function<String[], Integer>> commands = new HashMap<String, Function<String[], Integer>>();
        commands.put("hello", cmdArgs -> {
            terminal.writer().println("Hello, JLine!");
            return 0;
        });
        commands.put("echo", cmdArgs -> {
            if (((String[])cmdArgs).length > 1) {
                for (int i = 1; i < ((String[])cmdArgs).length; ++i) {
                    terminal.writer().print(cmdArgs[i]);
                    if (i >= ((String[])cmdArgs).length - 1) continue;
                    terminal.writer().print(" ");
                }
                terminal.writer().println();
            }
            return 0;
        });
        commands.put("pwd", cmdArgs -> {
            terminal.writer().println(workDir.toAbsolutePath());
            return 0;
        });
        commands.put("help", cmdArgs -> {
            terminal.writer().println("Available commands:");
            for (String cmd : commands.keySet()) {
                terminal.writer().println("  " + cmd);
            }
            return 0;
        });
        terminal.writer().println("SystemRegistry Example");
        terminal.writer().println("Available commands: hello, echo, pwd, help");
        terminal.writer().println("Type 'exit' to quit");
        terminal.writer().println();
        while (!(line = reader.readLine("registry> ")).equals("exit") && !line.equals("quit")) {
            try {
                ParsedLine pl = reader.getParser().parse(line, 0);
                String[] cmdArgs2 = pl.words().toArray(new String[0]);
                if (cmdArgs2.length > 0) {
                    String command = cmdArgs2[0];
                    if (commands.containsKey(command)) {
                        ((Function)commands.get(command)).apply(cmdArgs2);
                    } else {
                        terminal.writer().println("Unknown command: " + command);
                        terminal.writer().println("Type 'help' for a list of commands");
                    }
                }
            }
            catch (Exception e) {
                terminal.writer().println("Error: " + e.getMessage());
            }
            terminal.flush();
        }
        terminal.writer().println("Goodbye!");
        terminal.close();
    }
}

