/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jline.console.CmdDesc;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.widget.TailTipWidgets;

public class TailTipWidgetsExample {
    public static void main(String[] args) throws IOException {
        Terminal terminal = TerminalBuilder.builder().system(true).build();
        LineReader reader = LineReaderBuilder.builder().terminal(terminal).completer((Completer)new StringsCompleter(new String[]{"help", "widget", "exit", "clear"})).build();
        HashMap<String, CmdDesc> tailTips = new HashMap<String, CmdDesc>();
        tailTips.put("help", new CmdDesc(Arrays.asList(new AttributedString((CharSequence)"Display help information")), null, null));
        List<AttributedString> mainDesc = Arrays.asList(new AttributedString((CharSequence)"widget -N new-widget [function-name]"), new AttributedString((CharSequence)"widget -D widget ..."), new AttributedString((CharSequence)"widget -A old-widget new-widget"), new AttributedString((CharSequence)"widget -l [options]"));
        HashMap<String, List<AttributedString>> widgetOpts = new HashMap<String, List<AttributedString>>();
        widgetOpts.put("-N", Arrays.asList(new AttributedString((CharSequence)"Create new widget")));
        widgetOpts.put("-D", Arrays.asList(new AttributedString((CharSequence)"Delete widgets")));
        widgetOpts.put("-A", Arrays.asList(new AttributedString((CharSequence)"Create alias to widget")));
        widgetOpts.put("-l", Arrays.asList(new AttributedString((CharSequence)"List user-defined widgets")));
        tailTips.put("widget", new CmdDesc(mainDesc, null, widgetOpts));
        TailTipWidgets tailtipWidgets = new TailTipWidgets(reader, tailTips, 5, TailTipWidgets.TipType.COMPLETER);
        tailtipWidgets.enable();
        terminal.writer().println("TailTip Widgets Example");
        terminal.writer().println("----------------------");
        terminal.writer().println("As you type commands, you'll see suggestions and descriptions.");
        terminal.writer().println("Try typing 'widget' to see command options and descriptions.");
        terminal.writer().println("- Type 'exit' to quit");
        terminal.writer().println();
        while (true) {
            try {
                String line;
                while (!(line = reader.readLine("tailtip> ")).equalsIgnoreCase("exit")) {
                    if (line.equalsIgnoreCase("clear")) {
                        terminal.writer().print("\u001b[H\u001b[2J");
                        terminal.writer().flush();
                        continue;
                    }
                    terminal.writer().println("You entered: " + line);
                    terminal.writer().flush();
                }
            }
            catch (Exception e) {
                terminal.writer().println("Error: " + e.getMessage());
                terminal.writer().flush();
                continue;
            }
            break;
        }
        terminal.close();
    }
}

