/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import org.jline.terminal.Attributes;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class TerminalModesExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        try (Terminal terminal = TerminalBuilder.builder().build();){
            Attributes originalAttributes = terminal.getAttributes();
            boolean canonicalMode = originalAttributes.getLocalFlag(Attributes.LocalFlag.ICANON);
            terminal.writer().println("Terminal is currently in " + (canonicalMode ? "canonical" : "raw") + " mode");
            terminal.writer().flush();
            Attributes rawAttributes = new Attributes(originalAttributes);
            rawAttributes.setLocalFlag(Attributes.LocalFlag.ICANON, false);
            rawAttributes.setLocalFlag(Attributes.LocalFlag.ECHO, false);
            rawAttributes.setLocalFlag(Attributes.LocalFlag.ISIG, false);
            rawAttributes.setLocalFlag(Attributes.LocalFlag.IEXTEN, false);
            rawAttributes.setInputFlag(Attributes.InputFlag.IXON, false);
            rawAttributes.setInputFlag(Attributes.InputFlag.ICRNL, false);
            rawAttributes.setInputFlag(Attributes.InputFlag.INLCR, false);
            rawAttributes.setControlChar(Attributes.ControlChar.VMIN, 1);
            rawAttributes.setControlChar(Attributes.ControlChar.VTIME, 0);
            terminal.setAttributes(rawAttributes);
            terminal.writer().println("Switched to raw mode. Press any key to continue...");
            terminal.writer().flush();
            int c = terminal.reader().read();
            terminal.setAttributes(originalAttributes);
            terminal.writer().println("\nSwitched back to canonical mode");
            terminal.writer().println("You pressed: " + (char)c + " (ASCII: " + c + ")");
            terminal.writer().flush();
            terminal.writer().println("\nPress Enter to exit...");
            terminal.writer().flush();
            terminal.reader().read();
        }
    }
}

