/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class TerminalSizeExample {
    public static void main(String[] args) throws IOException, InterruptedException {
        Terminal terminal = TerminalBuilder.builder().build();
        Size size = terminal.getSize();
        terminal.writer().printf("Terminal size: %d columns x %d rows%n", size.getColumns(), size.getRows());
        terminal.writer().flush();
        terminal.handle(Terminal.Signal.WINCH, signal -> {
            Size newSize = terminal.getSize();
            terminal.writer().printf("Terminal resized: %d columns x %d rows%n", newSize.getColumns(), newSize.getRows());
            terminal.writer().flush();
        });
        terminal.writer().println("Resize your terminal window to see the size change.");
        terminal.writer().println("Press Enter to exit.");
        terminal.writer().flush();
        terminal.reader().read();
        terminal.close();
    }
}

