/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.InfoCmp;

public class TerminalSizeHandlingExample {
    public static void main(String[] args) throws IOException, InterruptedException {
        Terminal terminal = TerminalBuilder.builder().build();
        Size size = terminal.getSize();
        terminal.writer().println("Initial terminal size: " + size.getColumns() + "x" + size.getRows());
        terminal.writer().flush();
        CountDownLatch latch = new CountDownLatch(1);
        terminal.handle(Terminal.Signal.WINCH, signal -> {
            Size newSize = terminal.getSize();
            terminal.writer().println("\nTerminal resized: " + newSize.getColumns() + "x" + newSize.getRows());
            TerminalSizeHandlingExample.drawBox(terminal, newSize);
            terminal.writer().flush();
        });
        TerminalSizeHandlingExample.drawBox(terminal, size);
        terminal.writer().println("\nResize your terminal window to see the box adapt.");
        terminal.writer().println("Press Enter to exit.");
        terminal.writer().flush();
        terminal.reader().read();
        terminal.close();
    }

    private static void drawBox(Terminal terminal, Size size) {
        int i;
        int width = Math.min(size.getColumns() - 2, 78);
        int height = Math.min(size.getRows() - 5, 15);
        terminal.puts(InfoCmp.Capability.clear_screen, new Object[0]);
        terminal.writer().print("\u250c");
        for (i = 0; i < width; ++i) {
            terminal.writer().print("\u2500");
        }
        terminal.writer().println("\u2510");
        for (i = 0; i < height; ++i) {
            terminal.writer().print("\u2502");
            for (int j = 0; j < width; ++j) {
                terminal.writer().print(" ");
            }
            terminal.writer().println("\u2502");
        }
        terminal.writer().print("\u2514");
        for (i = 0; i < width; ++i) {
            terminal.writer().print("\u2500");
        }
        terminal.writer().println("\u2518");
        String sizeInfo = "Terminal size: " + size.getColumns() + "x" + size.getRows();
        int row = height / 2;
        int col = (width - sizeInfo.length()) / 2;
        terminal.puts(InfoCmp.Capability.cursor_address, new Object[]{row + 1, col + 1});
        terminal.writer().print(sizeInfo);
    }
}

