/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo;

import java.io.IOException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.terminal.spi.TerminalExt;

public class PasswordMaskingDemo {
    public static void main(String[] args) {
        Character mask = Character.valueOf('*');
        boolean skipDash = false;
        for (String arg : args) {
            if (arg.equals("--")) {
                skipDash = true;
                continue;
            }
            if (!skipDash || !arg.startsWith("--mask=")) continue;
            String maskStr = arg.substring("--mask=".length());
            mask = maskStr.isEmpty() ? null : Character.valueOf(maskStr.charAt(0));
        }
        try {
            String password;
            TerminalBuilder builder = TerminalBuilder.builder();
            Terminal terminal = builder.build();
            boolean isDumb = ((TerminalExt)terminal).getProvider().name().equals("dumb");
            if (isDumb) {
                System.out.println("Using dumb terminal");
                System.out.println("With dumb terminals, JLine3 uses a thread to continuously refresh the prompt,");
                System.out.println("effectively hiding your input. You won't see mask characters, but your input");
                System.out.println("will be hidden. This is similar to how JLine1 handled password input.");
            } else {
                System.out.println("Using regular terminal");
                if (mask != null) {
                    System.out.println("You should see each character replaced with: " + mask);
                } else {
                    System.out.println("No masking will be applied - you'll see what you type");
                }
            }
            LineReader reader = LineReaderBuilder.builder().terminal(terminal).build();
            if (mask != null) {
                System.out.println("\nReading password with mask: " + mask);
                password = reader.readLine("Enter password: ", mask);
            } else {
                System.out.println("\nReading password without masking");
                password = reader.readLine("Enter password: ");
            }
            System.out.println("Password entered: " + password);
            if (mask != null) {
                System.out.println("\nTry entering another password to verify the behavior:");
                password = reader.readLine("Enter another password: ", mask);
            } else {
                System.out.println("\nTry entering another password to verify the behavior:");
                password = reader.readLine("Enter another password: ");
            }
            System.out.println("Second password entered: " + password);
        }
        catch (IOException e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

