/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.consoleui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jline.consoleui.elements.ConfirmChoice;
import org.jline.consoleui.elements.PromptableElementIF;
import org.jline.consoleui.prompt.ConfirmResult;
import org.jline.consoleui.prompt.ConsolePrompt;
import org.jline.consoleui.prompt.PromptResultItemIF;
import org.jline.consoleui.prompt.builder.PromptBuilder;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.OSUtils;

public class BasicDynamic {
    private static final AttributedStyle ITALIC_GREEN = AttributedStyle.DEFAULT.italic().foreground(2);
    private static final AttributedStyle BOLD_RED = AttributedStyle.BOLD.foreground(1);

    private static void addInHeader(List<AttributedString> header, String text) {
        BasicDynamic.addInHeader(header, AttributedStyle.DEFAULT, text);
    }

    private static void addInHeader(List<AttributedString> header, AttributedStyle style, String text) {
        AttributedStringBuilder asb = new AttributedStringBuilder();
        asb.style(style).append((CharSequence)text);
        header.add(asb.toAttributedString());
    }

    public static void main(String[] args) {
        ArrayList<AttributedString> header = new ArrayList<AttributedString>();
        BasicDynamic.addInHeader(header, ITALIC_GREEN, "Hello Dynamic World!");
        BasicDynamic.addInHeader(header, "This is a demonstration of ConsoleUI java library. It provides a simple console interface");
        BasicDynamic.addInHeader(header, "for querying information from the user. ConsoleUI is inspired by Inquirer.js which is written");
        BasicDynamic.addInHeader(header, "in JavaScript.");
        try (Terminal terminal = TerminalBuilder.builder().build();){
            Thread executeThread = Thread.currentThread();
            terminal.handle(Terminal.Signal.INT, signal -> executeThread.interrupt());
            if (terminal.getType().equals("dumb") || terminal.getType().equals("dumb-color")) {
                System.out.println(terminal.getName() + ": " + terminal.getType());
                throw new IllegalStateException("Dumb terminal detected.\nConsoleUi requires real terminal to work!\nNote: On Windows Jansi or JNA library must be included in classpath.");
            }
            ConsolePrompt.UiConfig config = OSUtils.IS_WINDOWS ? new ConsolePrompt.UiConfig(">", "( )", "(x)", "( )") : new ConsolePrompt.UiConfig("\u276f", "\u25ef ", "\u25c9 ", "\u25ef ");
            config.setCancellableFirstPrompt(true);
            LineReader reader = LineReaderBuilder.builder().terminal(terminal).build();
            ConsolePrompt prompt = new ConsolePrompt(reader, terminal, config);
            Map result = prompt.prompt(header, results -> {
                if (results.isEmpty()) {
                    return BasicDynamic.pizzaOrHamburgerPrompt(prompt);
                }
                if ("Pizza".equals(((PromptResultItemIF)results.get("product")).getResult())) {
                    if (!results.containsKey("pizzatype")) {
                        return BasicDynamic.pizzaPrompt(prompt);
                    }
                } else if (!results.containsKey("hamburgertype")) {
                    return BasicDynamic.hamburgerPrompt(prompt);
                }
                if (!results.containsKey("payment")) {
                    return BasicDynamic.finalPrompt(prompt);
                }
                return null;
            });
            System.out.println("result = " + result);
            if (result.isEmpty()) {
                System.out.println("User cancelled order.");
            } else {
                ConfirmResult delivery = (ConfirmResult)result.get("delivery");
                if (delivery.getConfirmed() == ConfirmChoice.ConfirmationValue.YES) {
                    System.out.println("We will deliver the order in 5 minutes");
                }
            }
        }
        catch (UserInterruptException e) {
            System.out.println("<ctrl>-c pressed");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    static List<PromptableElementIF> pizzaOrHamburgerPrompt(ConsolePrompt prompt) {
        PromptBuilder promptBuilder = prompt.getPromptBuilder();
        promptBuilder.createInputPrompt().name("name").message("Please enter your name").defaultValue("John Doe").addCompleter((Completer)new StringsCompleter(new String[]{"Jim", "Jack", "John", "Donald", "Dock"})).addPrompt();
        promptBuilder.createListPrompt().name("product").message("What do you want to order?").newItem().text("Pizza").add().newItem().text("Hamburger").add().addPrompt();
        return promptBuilder.build();
    }

    static List<PromptableElementIF> pizzaPrompt(ConsolePrompt prompt) {
        PromptBuilder promptBuilder = prompt.getPromptBuilder();
        promptBuilder.createText().addLine(ITALIC_GREEN, "Pizza time!").addPrompt();
        promptBuilder.createListPrompt().name("pizzatype").message("Which pizza do you want?").newItem().text("Margherita").add().newItem("veneziana").text("Veneziana").add().newItem("hawai").text("Hawai").add().newItem("quattro").text("Quattro Stagioni").add().addPrompt();
        promptBuilder.createCheckboxPrompt().name("topping").message("Please select additional toppings:").newSeparator("standard toppings").add().newItem().name("cheese").text("Cheese").add().newItem("bacon").text("Bacon").add().newItem("onions").text("Onions").disabledText("Sorry. Out of stock.").add().newSeparator().text("special toppings").add().newItem("salami").text("Very hot salami").check().add().newItem("salmon").text("Smoked Salmon").add().newSeparator("and our speciality...").add().newItem("special").text("Anchovies, and olives").checked(true).add().addPrompt();
        return promptBuilder.build();
    }

    static List<PromptableElementIF> hamburgerPrompt(ConsolePrompt prompt) {
        PromptBuilder promptBuilder = prompt.getPromptBuilder();
        promptBuilder.createText().addLine(ITALIC_GREEN, "Hamburger time!").addPrompt();
        promptBuilder.createListPrompt().name("hamburgertype").message("Which hamburger do you want?").newItem().text("Cheeseburger").add().newItem("chickenburger").text("Chickenburger").add().newItem("veggieburger").text("Veggieburger").add().addPrompt();
        promptBuilder.createCheckboxPrompt().name("ingredients").message("Please select additional ingredients:").newSeparator("standard ingredients").add().newItem().name("tomato").text("Tomato").add().newItem("lettuce").text("Lettuce").add().newItem("onions").text("Onions").disabledText("Sorry. Out of stock.").add().newSeparator().text("special ingredients").add().newItem("crispybacon").text("Crispy Bacon").check().add().addPrompt();
        return promptBuilder.build();
    }

    static List<PromptableElementIF> finalPrompt(ConsolePrompt prompt) {
        PromptBuilder promptBuilder = prompt.getPromptBuilder();
        promptBuilder.createText().addLine(BOLD_RED, "###################").addLine(ITALIC_GREEN, "Finalize your order").addLine(BOLD_RED, "###################").addPrompt();
        promptBuilder.createChoicePrompt().name("payment").message("How do you want to pay?").newItem().name("cash").message("Cash").key('c').asDefault().add().newItem("visa").message("Visa Card").key('v').add().newItem("master").message("Master Card").key('m').add().newSeparator("online payment").add().newItem("paypal").message("Paypal").key('p').add().addPrompt();
        promptBuilder.createConfirmPromp().name("delivery").message("Is this order for delivery?").defaultValue(ConfirmChoice.ConfirmationValue.YES).addPrompt();
        return promptBuilder.build();
    }
}

