/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class AutoIndentationExample {
    public static void main(String[] args) throws IOException {
        Terminal terminal = TerminalBuilder.builder().system(true).build();
        DefaultParser parser = new DefaultParser();
        parser.setEofOnUnclosedBracket(new DefaultParser.Bracket[]{DefaultParser.Bracket.CURLY, DefaultParser.Bracket.ROUND, DefaultParser.Bracket.SQUARE});
        LineReader reader = LineReaderBuilder.builder().terminal(terminal).parser((Parser)parser).variable("secondary-prompt-pattern", (Object)"%M%P > ").variable("indentation", (Object)2).option(LineReader.Option.INSERT_BRACKET, true).build();
        terminal.writer().println("Auto Indentation Example");
        terminal.writer().println("------------------------");
        terminal.writer().println("Try typing multi-line code with brackets:");
        terminal.writer().println("Example: if (true) {");
        terminal.writer().println("Note: You need to manually close the last bracket");
        terminal.writer().println("Type 'exit' to quit");
        terminal.writer().println();
        while (true) {
            try {
                String line;
                while (!(line = reader.readLine("indent> ")).equalsIgnoreCase("exit")) {
                    terminal.writer().println("You entered: " + line);
                    terminal.writer().flush();
                }
            }
            catch (Exception e) {
                terminal.writer().println("Error: " + e.getMessage());
                terminal.writer().flush();
                continue;
            }
            break;
        }
        terminal.close();
    }
}

