/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import org.jline.keymap.BindingReader;
import org.jline.keymap.KeyMap;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Reference;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.InfoCmp;

public class CustomKeyBindingsExample {
    public static void main(String[] args) throws Exception {
        Terminal terminal = TerminalBuilder.builder().system(true).build();
        LineReader reader = LineReaderBuilder.builder().terminal(terminal).build();
        ((KeyMap)reader.getKeyMaps().get("main")).bind((Object)new Reference("transpose-chars"), (CharSequence)"\u0014");
        ((KeyMap)reader.getKeyMaps().get("main")).bind((Object)new Reference("up-case-word"), (CharSequence)"\u001bu");
        ((KeyMap)reader.getKeyMaps().get("main")).bind((Object)new Reference("down-case-word"), (CharSequence)"\u001bl");
        ((KeyMap)reader.getKeyMaps().get("main")).bind((Object)new Reference("capitalize-word"), (CharSequence)"\u001bc");
        ((KeyMap)reader.getKeyMaps().get("main")).bind((Object)new Reference("clear-screen"), (CharSequence)terminal.getStringCapability(InfoCmp.Capability.key_f5));
        ((KeyMap)reader.getKeyMaps().get("main")).bind((Object)new Reference("edit-and-execute-command"), (CharSequence)"\u0018\u0005");
        terminal.writer().println("Custom Key Bindings Example");
        terminal.writer().println("Try these key combinations:");
        terminal.writer().println("  Ctrl+T  - Transpose characters");
        terminal.writer().println("  Alt+U   - Uppercase word");
        terminal.writer().println("  Alt+L   - Lowercase word");
        terminal.writer().println("  Alt+C   - Capitalize word");
        terminal.writer().println("  F5      - Clear screen");
        terminal.writer().println("  Ctrl+X Ctrl+E - Edit command in external editor");
        terminal.writer().println();
        String line = reader.readLine("custom-keys> ");
        terminal.writer().println("You entered: " + line);
        terminal.writer().println("\nCustom KeyMap Example:");
        terminal.writer().println("Press 'q' to quit, 'h' for help, or 'a', 'b', 'c' for actions");
        KeyMap keyMap = new KeyMap();
        keyMap.bind((Object)"quit", (CharSequence)"q");
        keyMap.bind((Object)"help", (CharSequence)"h");
        keyMap.bind((Object)"action-a", (CharSequence)"a");
        keyMap.bind((Object)"action-b", (CharSequence)"b");
        keyMap.bind((Object)"action-c", (CharSequence)"c");
        BindingReader bindingReader = new BindingReader(terminal.reader());
        while (true) {
            String operation;
            if ("quit".equals(operation = (String)bindingReader.readBinding(keyMap))) break;
            if ("help".equals(operation)) {
                terminal.writer().println("Help: Press a, b, c for actions, q to quit");
            } else if ("action-a".equals(operation)) {
                terminal.writer().println("Executing action A");
            } else if ("action-b".equals(operation)) {
                terminal.writer().println("Executing action B");
            } else if ("action-c".equals(operation)) {
                terminal.writer().println("Executing action C");
            }
            terminal.flush();
        }
        terminal.writer().println("Quitting...");
        terminal.close();
    }
}

