/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;

public class CustomPromptExample {
    public static void main(String[] args) {
        try {
            Terminal terminal = TerminalBuilder.builder().system(true).build();
            LineReader reader = LineReaderBuilder.builder().terminal(terminal).build();
            reader.setVariable("prompt", (Object)"%N@%M:%w%n> ");
            reader.setVariable("rprompt", (Object)"%T");
            reader.setVariable("secondary-prompt-pattern", (Object)"%M> ");
            AttributedString prompt = new AttributedString((CharSequence)"jline> ", AttributedStyle.DEFAULT.foreground(2));
            AttributedString rightPrompt = new AttributedString((CharSequence)"[demo]", AttributedStyle.DEFAULT.foreground(4));
            try {
                String line1 = reader.readLine();
                terminal.writer().println("You entered: " + line1);
                String line2 = reader.readLine(prompt.toAnsi(), rightPrompt.toAnsi(), (Character)null, null);
                terminal.writer().println("You entered: " + line2);
                String line3 = reader.readLine("simple> ");
                terminal.writer().println("You entered: " + line3);
                String password = reader.readLine("Password: ", Character.valueOf('*'));
                terminal.writer().println("Password length: " + password.length());
            }
            catch (UserInterruptException e) {
                terminal.writer().println("Interrupted");
            }
            catch (EndOfFileException e) {
                terminal.writer().println("EOF");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

