/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Attributes;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class CustomTerminalBehaviorExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        try (Terminal terminal = TerminalBuilder.builder().build();){
            String line;
            Attributes originalAttributes = terminal.getAttributes();
            Attributes customAttributes = new Attributes(originalAttributes);
            customAttributes.setLocalFlag(Attributes.LocalFlag.ECHO, true);
            customAttributes.setLocalFlag(Attributes.LocalFlag.ICANON, true);
            customAttributes.setInputFlag(Attributes.InputFlag.ICRNL, true);
            customAttributes.setControlChar(Attributes.ControlChar.VINTR, 3);
            customAttributes.setControlChar(Attributes.ControlChar.VEOF, 4);
            customAttributes.setControlChar(Attributes.ControlChar.VSUSP, 26);
            terminal.setAttributes(customAttributes);
            terminal.writer().println("Terminal configured with custom attributes");
            terminal.writer().println("Type some text and press Enter (Ctrl+D to exit):");
            terminal.writer().flush();
            LineReader reader = LineReaderBuilder.builder().terminal(terminal).build();
            while ((line = reader.readLine(">")) != null) {
                terminal.writer().println("You typed: " + line);
                terminal.writer().println("Type another line (Ctrl+D to exit):");
                terminal.writer().flush();
            }
            terminal.setAttributes(originalAttributes);
        }
    }
}

