/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.jline.keymap.KeyMap;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Widget;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class CustomWidgetExample {
    public static void main(String[] args) throws IOException {
        Terminal terminal = TerminalBuilder.builder().build();
        LineReader reader = LineReaderBuilder.builder().terminal(terminal).build();
        Widget insertDateTimeWidget = () -> {
            String dateTime = LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            reader.getBuffer().write((CharSequence)dateTime);
            return true;
        };
        Widget uppercaseWordWidget = () -> {
            int end;
            int cursor;
            String buffer = reader.getBuffer().toString();
            int start = buffer.lastIndexOf(32, (cursor = reader.getBuffer().cursor()) - 1) + 1;
            if (start < 0) {
                start = 0;
            }
            if ((end = buffer.indexOf(32, cursor)) < 0) {
                end = buffer.length();
            }
            String word = buffer.substring(start, end);
            reader.getBuffer().cursor(start);
            reader.getBuffer().delete(end - start);
            reader.getBuffer().write((CharSequence)word.toUpperCase());
            return true;
        };
        reader.getWidgets().put("insert-date-time", insertDateTimeWidget);
        reader.getWidgets().put("uppercase-word", uppercaseWordWidget);
        KeyMap keyMap = (KeyMap)reader.getKeyMaps().get("main");
        keyMap.bind((Object)insertDateTimeWidget, (CharSequence)KeyMap.alt((char)'t'));
        keyMap.bind((Object)uppercaseWordWidget, (CharSequence)KeyMap.alt((char)'u'));
        terminal.writer().println("Custom Widget Example");
        terminal.writer().println("  Alt+T: Insert current date and time");
        terminal.writer().println("  Alt+U: Convert current word to uppercase");
        terminal.writer().println();
        String line = reader.readLine("widgets> ");
        terminal.writer().println("You entered: " + line);
        terminal.close();
    }
}

