/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.jline.keymap.KeyMap;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Widget;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class CustomWidgetsExample {
    public static void main(String[] args) throws IOException {
        String line;
        Terminal terminal = TerminalBuilder.builder().build();
        LineReader reader = LineReaderBuilder.builder().terminal(terminal).build();
        Widget insertDateWidget = () -> {
            String date = LocalDate.now().format(DateTimeFormatter.ISO_LOCAL_DATE);
            reader.getBuffer().write((CharSequence)date);
            return true;
        };
        Widget duplicateLineWidget = () -> {
            String currentLine = reader.getBuffer().toString();
            reader.getBuffer().write((CharSequence)("\n" + currentLine));
            return true;
        };
        Widget reverseWordWidget = () -> {
            String buffer = reader.getBuffer().toString();
            int cursor = reader.getBuffer().cursor();
            int start = buffer.lastIndexOf(32, cursor - 1) + 1;
            int end = buffer.indexOf(32, cursor);
            if (end == -1) {
                end = buffer.length();
            }
            String word = buffer.substring(start, end);
            reader.getBuffer().cursor(start);
            reader.getBuffer().delete(end - start);
            reader.getBuffer().write((CharSequence)new StringBuilder(word).reverse().toString());
            return true;
        };
        reader.getWidgets().put("insert-date", insertDateWidget);
        reader.getWidgets().put("duplicate-line", duplicateLineWidget);
        reader.getWidgets().put("reverse-word", reverseWordWidget);
        KeyMap keyMap = (KeyMap)reader.getKeyMaps().get("main");
        keyMap.bind((Object)insertDateWidget, (CharSequence)KeyMap.alt((char)'d'));
        keyMap.bind((Object)duplicateLineWidget, (CharSequence)KeyMap.alt((char)'l'));
        keyMap.bind((Object)reverseWordWidget, (CharSequence)KeyMap.alt((char)'r'));
        terminal.writer().println("Custom widgets:");
        terminal.writer().println("  Alt+D: Insert current date");
        terminal.writer().println("  Alt+L: Duplicate current line");
        terminal.writer().println("  Alt+R: Reverse current word");
        terminal.writer().println("\nType some text and try the custom widgets:");
        terminal.writer().flush();
        while (!(line = reader.readLine("prompt> ")).equalsIgnoreCase("exit")) {
            terminal.writer().println("You entered: " + line);
        }
        terminal.close();
    }
}

