/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;
import org.jline.utils.Display;

public class DisplayExample {
    public static void main(String[] args) throws IOException, InterruptedException {
        Terminal terminal = TerminalBuilder.builder().build();
        Display display = new Display(terminal, true);
        ArrayList<AttributedString> lines = new ArrayList<AttributedString>();
        lines.add(new AttributedString((CharSequence)"JLine Display Example"));
        lines.add(new AttributedString((CharSequence)"==================="));
        lines.add(new AttributedString((CharSequence)""));
        lines.add(new AttributedString((CharSequence)"This example demonstrates the Display class."));
        lines.add(new AttributedString((CharSequence)"The content will update every second."));
        display.resize(terminal.getHeight(), terminal.getWidth());
        display.update(lines, 0);
        for (int i = 0; i < 10; ++i) {
            TimeUnit.SECONDS.sleep(1L);
            StringBuilder progress = new StringBuilder("[");
            for (int j = 0; j < 10; ++j) {
                progress.append(j <= i ? "=" : " ");
            }
            progress.append("] ").append((i + 1) * 10).append("%");
            lines.set(4, new AttributedString((CharSequence)("Progress: " + progress), AttributedStyle.DEFAULT.foreground(2)));
            if (lines.size() <= 5) {
                lines.add(new AttributedString((CharSequence)""));
            }
            lines.set(5, new AttributedString((CharSequence)("Status: Processing step " + (i + 1) + " of 10"), AttributedStyle.DEFAULT.foreground(4)));
            display.update(lines, 0);
        }
        lines.set(4, new AttributedString((CharSequence)"Progress: [==========] 100%", AttributedStyle.DEFAULT.foreground(2)));
        lines.set(5, new AttributedString((CharSequence)"Status: Complete!", AttributedStyle.DEFAULT.foreground(4)));
        lines.add(new AttributedString((CharSequence)""));
        lines.add(new AttributedString((CharSequence)"Press Enter to exit"));
        display.update(lines, 0);
        terminal.reader().read();
        terminal.close();
    }
}

