/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import java.util.Stack;
import org.jline.reader.Highlighter;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class ErrorHighlightingExample {
    public static void main(String[] args) throws IOException {
        Highlighter parenthesesHighlighter = new Highlighter(){

            public AttributedString highlight(LineReader reader, String buffer) {
                AttributedStringBuilder builder = new AttributedStringBuilder();
                Stack<Integer> stack = new Stack<Integer>();
                boolean hasError = false;
                for (int i = 0; i < buffer.length(); ++i) {
                    char c = buffer.charAt(i);
                    if (c == '(') {
                        stack.push(i);
                        continue;
                    }
                    if (c != ')') continue;
                    if (stack.isEmpty()) {
                        hasError = true;
                        if (i > 0) {
                            builder.append((CharSequence)buffer.substring(0, i));
                        }
                        builder.styled(AttributedStyle.DEFAULT.foreground(7).background(1), (CharSequence)String.valueOf(c));
                        if (i >= buffer.length() - 1) break;
                        builder.append((CharSequence)buffer.substring(i + 1));
                        break;
                    }
                    stack.pop();
                }
                if (!hasError && !stack.isEmpty()) {
                    int errorPos = (Integer)stack.firstElement();
                    if (errorPos > 0) {
                        builder.append((CharSequence)buffer.substring(0, errorPos));
                    }
                    builder.styled(AttributedStyle.DEFAULT.foreground(7).background(1), (CharSequence)String.valueOf(buffer.charAt(errorPos)));
                    if (errorPos < buffer.length() - 1) {
                        builder.append((CharSequence)buffer.substring(errorPos + 1));
                    }
                } else if (!hasError) {
                    builder.append((CharSequence)buffer);
                }
                return builder.toAttributedString();
            }
        };
        Terminal terminal = TerminalBuilder.builder().build();
        LineReader reader = LineReaderBuilder.builder().terminal(terminal).highlighter(parenthesesHighlighter).build();
        terminal.writer().println("Parentheses Error Highlighting Example");
        terminal.writer().println("Try typing expressions with parentheses like: (1 + 2) * (3 - 4))");
        terminal.writer().println("Unbalanced parentheses will be highlighted in red");
        terminal.writer().println();
        String line = reader.readLine("expr> ");
        terminal.writer().println("You entered: " + line);
        terminal.close();
    }
}

