/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import org.jline.reader.Highlighter;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.impl.DefaultHighlighter;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class HighlighterExample {
    public static void main(String[] args) throws Exception {
        Terminal terminal = TerminalBuilder.builder().system(true).build();
        DefaultHighlighter highlighter = new DefaultHighlighter(){

            public AttributedString highlight(LineReader reader, String buffer) {
                AttributedStringBuilder builder = new AttributedStringBuilder();
                if (buffer.contains("error")) {
                    int index = buffer.indexOf("error");
                    builder.append((CharSequence)buffer.substring(0, index));
                    builder.styled(AttributedStyle.BOLD.foreground(1), (CharSequence)buffer.substring(index, index + 5));
                    builder.append((CharSequence)buffer.substring(index + 5));
                } else if (buffer.contains("warning")) {
                    int index = buffer.indexOf("warning");
                    builder.append((CharSequence)buffer.substring(0, index));
                    builder.styled(AttributedStyle.BOLD.foreground(3), (CharSequence)buffer.substring(index, index + 7));
                    builder.append((CharSequence)buffer.substring(index + 7));
                } else if (buffer.startsWith("command")) {
                    builder.styled(AttributedStyle.BOLD.foreground(4), (CharSequence)buffer);
                } else {
                    builder.append((CharSequence)buffer);
                }
                return builder.toAttributedString();
            }
        };
        LineReader reader = LineReaderBuilder.builder().terminal(terminal).highlighter((Highlighter)highlighter).build();
        String line = reader.readLine("Enter text (try 'error' or 'warning'): ");
        System.out.println("You entered: " + line);
        terminal.close();
    }
}

