/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class JCommanderJLineExample {
    public static void main(String[] args) {
        try {
            String line;
            Terminal terminal = TerminalBuilder.builder().system(true).build();
            LineReader reader = LineReaderBuilder.builder().terminal(terminal).build();
            terminal.writer().println("JCommander with JLine Example");
            terminal.writer().println("Available commands:");
            terminal.writer().println("  help                Show help");
            terminal.writer().println("  greet [--name=<name>] Greet someone");
            terminal.writer().println("  count [--number=<n>]  Count to a number");
            terminal.writer().println("  exit, quit          Exit the application");
            terminal.writer().println();
            while (!(line = reader.readLine("jcmd> ")).equalsIgnoreCase("exit") && !line.equalsIgnoreCase("quit")) {
                try {
                    String[] arguments = line.split("\\s+");
                    if (arguments.length > 0) {
                        int i;
                        String cmd = arguments[0];
                        if (cmd.equals("help") || cmd.equals("--help")) {
                            terminal.writer().println("Help information:");
                            terminal.writer().println("  help                Show this help message");
                            terminal.writer().println("  greet [--name=<name>] Greet someone");
                            terminal.writer().println("  count [--number=<n>]  Count to a number");
                            terminal.writer().println("  exit, quit          Exit the application");
                        } else if (cmd.equals("greet")) {
                            String name = "World";
                            for (i = 1; i < arguments.length; ++i) {
                                if (!arguments[i].startsWith("--name=")) continue;
                                name = arguments[i].substring(7);
                            }
                            terminal.writer().println("Hello, " + name + "!");
                        } else if (cmd.equals("count")) {
                            int number = 10;
                            for (i = 1; i < arguments.length; ++i) {
                                if (!arguments[i].startsWith("--number=")) continue;
                                try {
                                    number = Integer.parseInt(arguments[i].substring(9));
                                    continue;
                                }
                                catch (NumberFormatException e) {
                                    terminal.writer().println("Error: Invalid number format");
                                    number = 10;
                                }
                            }
                            for (i = 1; i <= number; ++i) {
                                terminal.writer().println(i);
                            }
                        } else {
                            terminal.writer().println("Unknown command: " + cmd);
                            terminal.writer().println("Type 'help' for usage information.");
                        }
                    }
                }
                catch (Exception e) {
                    terminal.writer().println("Error: " + e.getMessage());
                    terminal.writer().println("Type 'help' for usage information.");
                }
                terminal.flush();
            }
            terminal.writer().println("Goodbye!");
            terminal.close();
        }
        catch (IOException e) {
            System.err.println("Error creating terminal: " + e.getMessage());
        }
    }
}

