/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import java.util.ArrayList;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;
import org.jline.utils.Display;

public class MouseInteractiveUIExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        Terminal terminal = TerminalBuilder.builder().build();
        try {
            terminal.trackMouse(Terminal.MouseTracking.Normal);
            Display display = new Display(terminal, true);
            ArrayList<Button> buttons = new ArrayList<Button>();
            buttons.add(new Button(5, 3, "Button 1", () -> {
                terminal.writer().println("Button 1 clicked!");
                terminal.flush();
            }));
            buttons.add(new Button(5, 5, "Button 2", () -> {
                terminal.writer().println("Button 2 clicked!");
                terminal.flush();
            }));
            buttons.add(new Button(5, 7, "Exit", () -> {}));
            display.clear();
            terminal.writer().println("Interactive UI Example");
            terminal.writer().println("Click on the buttons below:");
            terminal.writer().println();
            for (Button button : buttons) {
                button.render(terminal);
            }
            terminal.flush();
            boolean running = true;
            StringBuilder buffer = new StringBuilder();
            boolean esc = false;
            boolean bracket = false;
            boolean mouse = false;
            while (running) {
                int c = terminal.reader().read();
                if (c == 27) {
                    esc = true;
                    buffer.setLength(0);
                    continue;
                }
                if (esc && c == 91) {
                    bracket = true;
                    continue;
                }
                if (esc && bracket && c == 77) {
                    mouse = true;
                    buffer.setLength(0);
                    continue;
                }
                if (mouse && buffer.length() < 3) {
                    buffer.append((char)c);
                    if (buffer.length() != 3) continue;
                    int b = buffer.charAt(0) - 32;
                    int x = buffer.charAt(1) - 32;
                    int y = buffer.charAt(2) - 32;
                    if ((b & 3) != 3 && (b & 0x40) == 0) {
                        for (Button button : buttons) {
                            if (!button.isInside(x, y)) continue;
                            button.click();
                            if (!button.getText().equals("Exit")) break;
                            running = false;
                            break;
                        }
                    }
                    esc = false;
                    bracket = false;
                    mouse = false;
                    continue;
                }
                esc = false;
                bracket = false;
                mouse = false;
            }
        }
        finally {
            terminal.trackMouse(Terminal.MouseTracking.Off);
            terminal.close();
        }
    }

    static class Button {
        private final int x;
        private final int y;
        private final String text;
        private final Runnable action;

        public Button(int x, int y, String text, Runnable action) {
            this.x = x;
            this.y = y;
            this.text = text;
            this.action = action;
        }

        public void render(Terminal terminal) {
            terminal.writer().write("\u001b[" + this.y + ";" + this.x + "H");
            AttributedString buttonText = new AttributedString((CharSequence)("[ " + this.text + " ]"), AttributedStyle.DEFAULT.foreground(4).bold());
            buttonText.print(terminal);
        }

        public boolean isInside(int mouseX, int mouseY) {
            return mouseY == this.y && mouseX >= this.x && mouseX < this.x + this.text.length() + 4;
        }

        public void click() {
            this.action.run();
        }

        public String getText() {
            return this.text;
        }
    }
}

